/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.instantexecution.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.instantexecution.initialization.InstantExecutionProblemsListener;
import org.gradle.instantexecution.problems.InstantExecutionProblems;
import org.gradle.instantexecution.problems.PropertyProblem;
import org.gradle.instantexecution.problems.PropertyTrace;
import org.gradle.instantexecution.problems.StructuredMessage;
import org.gradle.internal.InternalListener;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gradle/instantexecution/initialization/DefaultInstantExecutionProblemsListener;", "Lorg/gradle/instantexecution/initialization/InstantExecutionProblemsListener;", "problems", "Lorg/gradle/instantexecution/problems/InstantExecutionProblems;", "(Lorg/gradle/instantexecution/problems/InstantExecutionProblems;)V", "listenerRegistrationProblem", "Lorg/gradle/instantexecution/problems/PropertyProblem;", "trace", "Lorg/gradle/instantexecution/problems/PropertyTrace;", "invocationDescription", "", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "onBuildScopeListenerRegistration", "", "listener", "", "invocationSource", "onProjectAccess", "task", "Lorg/gradle/api/internal/TaskInternal;", "onTaskDependenciesAccess", "onTaskExecutionAccessProblem", "taskExecutionAccessProblem", "gradle-instant-execution"})
public final class DefaultInstantExecutionProblemsListener
implements InstantExecutionProblemsListener {
    private final InstantExecutionProblems problems;

    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkParameterIsNotNull((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkParameterIsNotNull((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task) {
        InvalidUserCodeException exception = new InvalidUserCodeException("Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported.");
        Class clazz = GeneratedSubclasses.unpackType((Object)task);
        Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"GeneratedSubclasses.unpackType(task)");
        Path path = task.getIdentityPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"task.identityPath");
        String string = path.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.identityPath.path");
        this.problems.onProblem(this.taskExecutionAccessProblem(new PropertyTrace.Task(clazz, string), invocationDescription, exception));
    }

    private final PropertyProblem taskExecutionAccessProblem(PropertyTrace trace, String invocationDescription, InvalidUserCodeException exception) {
        return new PropertyProblem(trace, StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkParameterIsNotNull((Object)$this$build, (String)"$receiver");
                $this$build.text("invocation of ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" at execution time is unsupported.");
            }
            {
                this.$invocationDescription = string;
                super(1);
            }
        })), (Throwable)exception, "use_project_during_execution");
    }

    public void onBuildScopeListenerRegistration(@NotNull Object listener, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkParameterIsNotNull((Object)invocationSource, (String)"invocationSource");
        if (!(listener instanceof InternalListener) && !(listener instanceof ProjectEvaluationListener)) {
            InvalidUserCodeException exception = new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.");
            this.problems.onProblem(this.listenerRegistrationProblem(PropertyTrace.Unknown.INSTANCE, invocationDescription, exception));
        }
    }

    private final PropertyProblem listenerRegistrationProblem(PropertyTrace trace, String invocationDescription, InvalidUserCodeException exception) {
        return new PropertyProblem(trace, StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkParameterIsNotNull((Object)$this$build, (String)"$receiver");
                $this$build.text("registration of listener on ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" is unsupported");
            }
            {
                this.$invocationDescription = string;
                super(1);
            }
        })), (Throwable)exception, "build_listeners");
    }

    public DefaultInstantExecutionProblemsListener(@NotNull InstantExecutionProblems problems) {
        Intrinsics.checkParameterIsNotNull((Object)problems, (String)"problems");
        this.problems = problems;
    }
}

