/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;

public class RecompilationSpec {
    private final Collection<String> classesToCompile = new LinkedHashSet<String>();
    private final Collection<String> classesToProcess = new LinkedHashSet<String>();
    private final Collection<GeneratedResource> resourcesToGenerate = new LinkedHashSet<GeneratedResource>();
    private final Set<String> relativeSourcePathsToCompile = new LinkedHashSet<String>();
    private String fullRebuildCause;

    public String toString() {
        return "RecompilationSpec{classesToCompile=" + this.classesToCompile + ", classesToProcess=" + this.classesToProcess + ", resourcesToGenerate=" + this.resourcesToGenerate + ", relativeSourcePathsToCompile=" + this.relativeSourcePathsToCompile + ", fullRebuildCause='" + this.fullRebuildCause + '\'' + ", buildNeeded=" + this.isBuildNeeded() + ", fullRebuildNeeded=" + this.isFullRebuildNeeded() + '}';
    }

    public Collection<String> getClassesToCompile() {
        return this.classesToCompile;
    }

    public Set<String> getRelativeSourcePathsToCompile() {
        return this.relativeSourcePathsToCompile;
    }

    public Collection<String> getClassesToProcess() {
        return this.classesToProcess;
    }

    public Collection<GeneratedResource> getResourcesToGenerate() {
        return this.resourcesToGenerate;
    }

    public boolean isBuildNeeded() {
        return this.isFullRebuildNeeded() || !this.classesToCompile.isEmpty() || !this.classesToProcess.isEmpty() || !this.relativeSourcePathsToCompile.isEmpty();
    }

    public boolean isFullRebuildNeeded() {
        return this.fullRebuildCause != null;
    }

    public String getFullRebuildCause() {
        return this.fullRebuildCause;
    }

    public void setFullRebuildCause(String description, File file) {
        this.fullRebuildCause = description != null ? description : "'" + file.getName() + "' was changed";
    }
}

