/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.DefaultPlannedTask;
import org.gradle.initialization.TaskExecutionPreparer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;

public class BuildOperatingFiringTaskExecutionPreparer
implements TaskExecutionPreparer {
    private final TaskExecutionPreparer delegate;
    private final BuildOperationExecutor buildOperationExecutor;

    public BuildOperatingFiringTaskExecutionPreparer(TaskExecutionPreparer delegate, BuildOperationExecutor buildOperationExecutor) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public void prepareForTaskExecution(GradleInternal gradle) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new CalculateTaskGraph(gradle));
    }

    private static List<CalculateTaskGraphBuildOperationType.TaskIdentity> traverseNonTasks(Collection<Node> nodes, Function<? super Node, ? extends Collection<Node>> traverser) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CalculateTaskGraphBuildOperationType.TaskIdentity> list = new ArrayList<CalculateTaskGraphBuildOperationType.TaskIdentity>();
        BuildOperatingFiringTaskExecutionPreparer.traverseNonTasks(nodes, traverser, Collections.newSetFromMap(new IdentityHashMap())).forEach(taskNode -> list.add(BuildOperatingFiringTaskExecutionPreparer.toIdentity(taskNode)));
        return list;
    }

    private static Iterable<TaskNode> traverseNonTasks(Collection<Node> nodes, Function<? super Node, ? extends Collection<Node>> traverser, Set<Node> seen) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return FluentIterable.from(nodes).filter(seen::add).transformAndConcat(node -> node instanceof TaskNode ? Collections.singleton((TaskNode)node) : BuildOperatingFiringTaskExecutionPreparer.traverseNonTasks(Objects.requireNonNull((Collection)traverser.apply(node)), traverser, seen));
    }

    private static List<CalculateTaskGraphBuildOperationType.TaskIdentity> filterNonTasks(Collection<Node> nodes) {
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        return FluentIterable.from(nodes).filter(TaskNode.class).transform(BuildOperatingFiringTaskExecutionPreparer::toIdentity).toList();
    }

    private static CalculateTaskGraphBuildOperationType.TaskIdentity toIdentity(TaskNode n) {
        return new PlannedTaskIdentity(n.getTask().getTaskIdentity());
    }

    private static List<String> toTaskPaths(Set<Task> tasks) {
        return ImmutableSortedSet.copyOf((Collection)Collections2.transform(tasks, Task::getPath)).asList();
    }

    private static class PlannedTaskIdentity
    implements CalculateTaskGraphBuildOperationType.TaskIdentity {
        private final TaskIdentity<?> delegate;

        public PlannedTaskIdentity(TaskIdentity<?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getBuildPath() {
            return this.delegate.getBuildPath();
        }

        @Override
        public String getTaskPath() {
            return this.delegate.getTaskPath();
        }

        @Override
        public long getTaskId() {
            return this.delegate.getId();
        }
    }

    private class CalculateTaskGraph
    implements RunnableBuildOperation {
        private final GradleInternal gradle;

        public CalculateTaskGraph(GradleInternal gradle) {
            this.gradle = gradle;
        }

        public void run(BuildOperationContext buildOperationContext) {
            TaskExecutionGraphInternal taskGraph = this.populateTaskGraph();
            final Set<Task> requestedTasks = taskGraph.getRequestedTasks();
            final Set<Task> filteredTasks = taskGraph.getFilteredTasks();
            final List<Node> scheduledWork = taskGraph.getScheduledWork();
            buildOperationContext.setResult((Object)new CalculateTaskGraphBuildOperationType.Result(){

                @Override
                public List<String> getRequestedTaskPaths() {
                    return BuildOperatingFiringTaskExecutionPreparer.toTaskPaths(requestedTasks);
                }

                @Override
                public List<String> getExcludedTaskPaths() {
                    return BuildOperatingFiringTaskExecutionPreparer.toTaskPaths(filteredTasks);
                }

                @Override
                public List<CalculateTaskGraphBuildOperationType.PlannedTask> getTaskPlan() {
                    return this.toPlannedTasks(scheduledWork);
                }

                private List<CalculateTaskGraphBuildOperationType.PlannedTask> toPlannedTasks(List<Node> scheduledWork2) {
                    ArrayList<CalculateTaskGraphBuildOperationType.PlannedTask> plannedTasks = new ArrayList<CalculateTaskGraphBuildOperationType.PlannedTask>();
                    for (Node node : scheduledWork2) {
                        if (!(node instanceof TaskNode)) continue;
                        TaskNode taskNode = (TaskNode)node;
                        plannedTasks.add(this.toPlannedTask(taskNode));
                    }
                    return plannedTasks;
                }

                private CalculateTaskGraphBuildOperationType.PlannedTask toPlannedTask(TaskNode taskNode) {
                    TaskIdentity<?> taskIdentity = taskNode.getTask().getTaskIdentity();
                    return new DefaultPlannedTask(new PlannedTaskIdentity(taskIdentity), BuildOperatingFiringTaskExecutionPreparer.traverseNonTasks(taskNode.getDependencySuccessors(), (Function<? super Node, ? extends Collection<Node>>)Node::getDependencySuccessors), BuildOperatingFiringTaskExecutionPreparer.filterNonTasks(taskNode.getMustSuccessors()), BuildOperatingFiringTaskExecutionPreparer.filterNonTasks(taskNode.getShouldSuccessors()), BuildOperatingFiringTaskExecutionPreparer.filterNonTasks(taskNode.getFinalizers()));
                }
            });
        }

        TaskExecutionGraphInternal populateTaskGraph() {
            BuildOperatingFiringTaskExecutionPreparer.this.delegate.prepareForTaskExecution(this.gradle);
            return this.gradle.getTaskGraph();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Calculate task graph")).details((Object)new CalculateTaskGraphBuildOperationType.Details(){

                @Override
                public String getBuildPath() {
                    return CalculateTaskGraph.this.gradle.getIdentityPath().getPath();
                }
            });
        }
    }
}

