/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.concurrency;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import sun.misc.Unsafe;

public class AtomicFieldUpdater<ContainingClass, FieldType> {
    private static final Unsafe unsafe = ReflectionUtil.getStaticFieldValue(Unsafe.class, Unsafe.class, "theUnsafe");
    private final long offset;

    @NotNull
    public static Unsafe getUnsafe() {
        Unsafe unsafe = AtomicFieldUpdater.unsafe;
        if (unsafe == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(0);
        }
        return unsafe;
    }

    @NotNull
    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(@NotNull Class<T> ownerClass, @NotNull Class<V> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(1);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(2);
        }
        return new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
    }

    @NotNull
    public static <T> AtomicFieldUpdater<T, Long> forLongFieldIn(@NotNull Class<T> ownerClass) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(3);
        }
        return new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
    }

    private AtomicFieldUpdater(@NotNull Class<ContainingClass> ownerClass, @NotNull Class<FieldType> fieldType) {
        if (ownerClass == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(6);
        }
        if (fieldType == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(7);
        }
        this(ReflectionUtil.getTheOnlyVolatileInstanceFieldOfClass(ownerClass, fieldType));
    }

    private AtomicFieldUpdater(@NotNull Field field) {
        if (field == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(8);
        }
        field.setAccessible(true);
        if (!Modifier.isVolatile(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            throw new IllegalArgumentException(field + " must be volatile instance");
        }
        this.offset = unsafe.objectFieldOffset(field);
    }

    public boolean compareAndSet(@NotNull ContainingClass owner, FieldType expected, FieldType newValue2) {
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(9);
        }
        return unsafe.compareAndSwapObject(owner, this.offset, expected, newValue2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean compareAndSetLong(@NotNull ContainingClass owner, long expected, long l) {
        void newValue2;
        if (owner == null) {
            AtomicFieldUpdater.$$$reportNull$$$0(10);
        }
        return unsafe.compareAndSwapLong(owner, this.offset, expected, (long)newValue2);
    }

    static {
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the " + Unsafe.class);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/concurrency/AtomicFieldUpdater";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsafe";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/concurrency/AtomicFieldUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forFieldOfType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forLongFieldIn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forIntFieldIn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forField";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSet";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetLong";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareAndSetInt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

