/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.build.PublicBuildPath;
import org.gradle.plugin.management.internal.PluginRequests;

public class BuildDefinition {
    @Nullable
    private final String name;
    @Nullable
    private final File buildRootDir;
    private final StartParameter startParameter;
    private final PluginRequests injectedSettingsPlugins;
    private final Action<? super DependencySubstitutions> dependencySubstitutions;
    private final PublicBuildPath fromBuild;

    private BuildDefinition(@Nullable String name, @Nullable File buildRootDir, StartParameter startParameter, PluginRequests injectedSettingsPlugins, Action<? super DependencySubstitutions> dependencySubstitutions, PublicBuildPath fromBuild) {
        this.name = name;
        this.buildRootDir = buildRootDir;
        this.startParameter = startParameter;
        this.injectedSettingsPlugins = injectedSettingsPlugins;
        this.dependencySubstitutions = dependencySubstitutions;
        this.fromBuild = fromBuild;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public File getBuildRootDir() {
        return this.buildRootDir;
    }

    @Nullable
    public PublicBuildPath getFromBuild() {
        return this.fromBuild;
    }

    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public PluginRequests getInjectedPluginRequests() {
        return this.injectedSettingsPlugins;
    }

    public Action<? super DependencySubstitutions> getDependencySubstitutions() {
        return this.dependencySubstitutions;
    }

    public static BuildDefinition fromStartParameterForBuild(StartParameter startParameter, String name, File buildRootDir, PluginRequests pluginRequests, Action<? super DependencySubstitutions> dependencySubstitutions, PublicBuildPath fromBuild) {
        return new BuildDefinition(name, buildRootDir, BuildDefinition.configure(startParameter, buildRootDir), pluginRequests, dependencySubstitutions, fromBuild);
    }

    public static BuildDefinition fromStartParameter(StartParameter startParameter, @Nullable PublicBuildPath fromBuild) {
        return new BuildDefinition(null, null, startParameter, PluginRequests.EMPTY, (Action<? super DependencySubstitutions>)Actions.doNothing(), fromBuild);
    }

    private static StartParameter configure(StartParameter startParameter, File buildRootDir) {
        StartParameter includedBuildStartParam = startParameter.newBuild();
        includedBuildStartParam.setCurrentDir(buildRootDir);
        ((StartParameterInternal)includedBuildStartParam).setSearchUpwardsWithoutDeprecationWarning(false);
        includedBuildStartParam.setConfigureOnDemand(false);
        includedBuildStartParam.setInitScripts(startParameter.getInitScripts());
        return includedBuildStartParam;
    }

    public BuildDefinition newInstance() {
        return new BuildDefinition(this.name, this.buildRootDir, this.startParameter.newInstance(), this.injectedSettingsPlugins, this.dependencySubstitutions, this.fromBuild);
    }
}

