/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.gradle.internal.SystemProperties;

public class TextUtil {
    private static final Pattern WHITESPACE = Pattern.compile("\\s*");
    private static final Pattern UPPER_CASE = Pattern.compile("(?=\\p{Upper})");
    private static final Joiner KEBAB_JOINER = Joiner.on((String)"-");
    private static final Function<String, String> TO_LOWERCASE = new Function<String, String>(){

        public String apply(String input) {
            return input.toLowerCase();
        }
    };
    private static final Pattern NON_UNIX_LINE_SEPARATORS = Pattern.compile("\r\n|\r");

    public static String getWindowsLineSeparator() {
        return "\r\n";
    }

    public static String getUnixLineSeparator() {
        return "\n";
    }

    public static String getPlatformLineSeparator() {
        return SystemProperties.getInstance().getLineSeparator();
    }

    @Nullable
    public static String convertLineSeparators(@Nullable String str, String sep) {
        return str == null ? null : TextUtil.replaceLineSeparatorsOf(str, sep);
    }

    public static String convertLineSeparatorsToUnix(String str) {
        return TextUtil.replaceAll(NON_UNIX_LINE_SEPARATORS, (CharSequence)str, "\n");
    }

    public static String replaceLineSeparatorsOf(CharSequence string, String bySeparator) {
        return TextUtil.replaceAll("\r\n|\r|\n", string, bySeparator);
    }

    private static String replaceAll(String regex, CharSequence inString, String byString) {
        return TextUtil.replaceAll(Pattern.compile(regex), inString, byString);
    }

    private static String replaceAll(Pattern pattern, CharSequence inString, String byString) {
        return pattern.matcher(inString).replaceAll(byString);
    }

    public static String toPlatformLineSeparators(String str) {
        return str == null ? null : TextUtil.replaceLineSeparatorsOf(str, TextUtil.getPlatformLineSeparator());
    }

    @Nullable
    public static String normaliseLineSeparators(@Nullable String str) {
        return str == null ? null : TextUtil.convertLineSeparatorsToUnix(str);
    }

    public static String normaliseFileSeparators(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static String escapeString(Object obj) {
        return obj == null ? null : StringEscapeUtils.escapeJava((String)obj.toString());
    }

    public static boolean containsWhitespace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String indent(String text, String indent) {
        StringBuilder builder = new StringBuilder();
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!WHITESPACE.matcher(line).matches()) {
                builder.append(indent);
            }
            builder.append(line);
            if (i >= lines.length - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public static String shorterOf(String s1, String s2) {
        if (s2.length() >= s1.length()) {
            return s1;
        }
        return s2;
    }

    public static String minus(String originalString, String removeString) {
        String s = originalString.toString();
        int index = s.indexOf(removeString);
        if (index == -1) {
            return s;
        }
        int end = index + removeString.length();
        if (s.length() > end) {
            return s.substring(0, index) + s.substring(end);
        }
        return s.substring(0, index);
    }

    public static String normaliseFileAndLineSeparators(String in) {
        return TextUtil.normaliseLineSeparators(TextUtil.normaliseFileSeparators(in));
    }

    public static String camelToKebabCase(String camelCase) {
        return KEBAB_JOINER.join(Iterables.transform(Arrays.asList(UPPER_CASE.split(camelCase)), TO_LOWERCASE));
    }
}

