/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.rubygrapefruit.platform.file.FileWatcher;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.watch.registry.FileWatcherUpdater;
import org.gradle.internal.watch.registry.impl.SnapshotWatchedDirectoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HierarchicalFileWatcherUpdater
implements FileWatcherUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(HierarchicalFileWatcherUpdater.class);
    private final Multimap<String, Path> trackedDirectoriesForSnapshot = HashMultimap.create();
    private final Set<Path> watchedHierarchies = new HashSet<Path>();
    private final Set<Path> knownRootProjectDirectoriesFromCurrentBuild = new HashSet<Path>();
    private final Set<Path> watchedRootProjectDirectoriesFromPreviousBuild = new HashSet<Path>();
    private final FileWatcher watcher;

    public HierarchicalFileWatcherUpdater(FileWatcher watcher) {
        this.watcher = watcher;
    }

    @Override
    public void changed(Collection<CompleteFileSystemLocationSnapshot> removedSnapshots, Collection<CompleteFileSystemLocationSnapshot> addedSnapshots) {
        removedSnapshots.forEach(snapshot -> this.trackedDirectoriesForSnapshot.removeAll((Object)snapshot.getAbsolutePath()));
        addedSnapshots.forEach(snapshot -> {
            ImmutableList<Path> directoriesToWatch = SnapshotWatchedDirectoryFinder.getDirectoriesToWatch(snapshot);
            this.trackedDirectoriesForSnapshot.putAll((Object)snapshot.getAbsolutePath(), directoriesToWatch);
        });
        this.determineAndUpdateWatchedHierarchies();
    }

    @Override
    public void buildFinished() {
        this.watchedRootProjectDirectoriesFromPreviousBuild.addAll(this.knownRootProjectDirectoriesFromCurrentBuild);
        this.watchedRootProjectDirectoriesFromPreviousBuild.retainAll(this.watchedHierarchies);
        this.knownRootProjectDirectoriesFromCurrentBuild.clear();
        this.determineAndUpdateWatchedHierarchies();
    }

    @Override
    public void updateRootProjectDirectories(Collection<File> updatedRootProjectDirectories) {
        Set<Path> rootPaths = updatedRootProjectDirectories.stream().map(File::toPath).map(Path::toAbsolutePath).collect(Collectors.toSet());
        Set<Path> newRootProjectDirectories = HierarchicalFileWatcherUpdater.resolveHierarchiesToWatch(rootPaths);
        LOGGER.info("Now considering watching {} as root project directories", newRootProjectDirectories);
        this.knownRootProjectDirectoriesFromCurrentBuild.clear();
        this.knownRootProjectDirectoriesFromCurrentBuild.addAll(newRootProjectDirectories);
        this.watchedRootProjectDirectoriesFromPreviousBuild.removeAll(this.knownRootProjectDirectoriesFromCurrentBuild);
        this.determineAndUpdateWatchedHierarchies();
    }

    private void determineAndUpdateWatchedHierarchies() {
        Set<Path> hierarchiesToWatch = this.determineHierarchiesToWatch();
        this.updateWatchedHierarchies(hierarchiesToWatch);
    }

    private Set<Path> determineHierarchiesToWatch() {
        Set<Path> directoriesToWatch = this.trackedDirectoriesForSnapshot.values().stream().map(trackedDirectory -> Stream.concat(this.knownRootProjectDirectoriesFromCurrentBuild.stream(), this.watchedRootProjectDirectoriesFromPreviousBuild.stream()).filter(trackedDirectory::startsWith).findFirst().orElse((Path)trackedDirectory)).collect(Collectors.toSet());
        return HierarchicalFileWatcherUpdater.resolveHierarchiesToWatch(directoriesToWatch);
    }

    private void updateWatchedHierarchies(Set<Path> newHierarchiesToWatch) {
        if (newHierarchiesToWatch.isEmpty()) {
            LOGGER.info("Not watching anything anymore");
        }
        HashSet<Path> hierarchiesToStopWatching = new HashSet<Path>(this.watchedHierarchies);
        HashSet<Path> hierarchiesToStartWatching = new HashSet<Path>(newHierarchiesToWatch);
        hierarchiesToStopWatching.removeAll(newHierarchiesToWatch);
        hierarchiesToStartWatching.removeAll(this.watchedHierarchies);
        if (hierarchiesToStartWatching.isEmpty() && hierarchiesToStopWatching.isEmpty()) {
            return;
        }
        if (!hierarchiesToStopWatching.isEmpty()) {
            this.watcher.stopWatching((Collection)hierarchiesToStopWatching.stream().map(Path::toFile).collect(Collectors.toList()));
            this.watchedHierarchies.removeAll(hierarchiesToStopWatching);
        }
        if (!hierarchiesToStartWatching.isEmpty()) {
            this.watcher.startWatching((Collection)hierarchiesToStartWatching.stream().map(Path::toFile).collect(Collectors.toList()));
            this.watchedHierarchies.addAll(hierarchiesToStartWatching);
        }
        LOGGER.info("Watching {} directory hierarchies to track changes", (Object)this.watchedHierarchies.size());
    }

    @VisibleForTesting
    static Set<Path> resolveHierarchiesToWatch(Set<Path> directories) {
        HashSet<Path> hierarchies = new HashSet<Path>();
        directories.stream().sorted(Comparator.comparingInt(Path::getNameCount)).filter(path -> {
            Path parent = path;
            while ((parent = parent.getParent()) != null) {
                if (!hierarchies.contains(parent)) continue;
                return false;
            }
            return true;
        }).forEach(hierarchies::add);
        return hierarchies;
    }
}

