/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.util.Path;

public class DefaultProjectComponentIdentifier
implements ProjectComponentIdentifier {
    private final BuildIdentifier buildIdentifier;
    private final Path projectPath;
    private final Path identityPath;
    private final String projectName;
    private String displayName;

    public DefaultProjectComponentIdentifier(BuildIdentifier buildIdentifier, Path identityPath, Path projectPath, String projectName) {
        assert (buildIdentifier != null) : "build cannot be null";
        assert (identityPath != null) : "identity path cannot be null";
        assert (projectPath != null) : "project path cannot be null";
        assert (projectName != null) : "project name cannot be null";
        this.identityPath = identityPath;
        this.projectName = projectName;
        this.buildIdentifier = buildIdentifier;
        this.projectPath = projectPath;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = "project " + this.identityPath.getPath();
        }
        return this.displayName;
    }

    public BuildIdentifier getBuild() {
        return this.buildIdentifier;
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    public String getProjectPath() {
        return this.projectPath.getPath();
    }

    public Path projectPath() {
        return this.projectPath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectComponentIdentifier that = (DefaultProjectComponentIdentifier)o;
        return this.identityPath.equals((Object)that.identityPath);
    }

    public int hashCode() {
        return this.identityPath.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }
}

