/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.GroovyProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.ScriptBlockBuilder;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;

public class GroovyApplicationProjectInitDescriptor
extends GroovyProjectInitDescriptor {
    public GroovyApplicationProjectInitDescriptor(TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(libraryVersionProvider, documentationRegistry);
    }

    @Override
    public String getId() {
        return "groovy-application";
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.APPLICATION;
    }

    @Override
    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.plugin("Apply the application plugin to add support for building a CLI application.", "application").block(null, "application", (Action<? super ScriptBlockBuilder>)((Action)b -> b.propertyAssignment("Define the main class for the application.", "mainClassName", this.withPackage(settings, "App"))));
    }

    @Override
    protected TemplateOperation sourceTemplateOperation(TemplateFactory templateFactory) {
        return templateFactory.fromSourceTemplate("groovyapp/App.groovy.template", "main");
    }

    @Override
    protected TemplateOperation testTemplateOperation(TemplateFactory templateFactory) {
        return templateFactory.fromSourceTemplate("groovyapp/AppTest.groovy.template", "test");
    }
}

