/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.instantexecution.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.TaskInternal;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.instantexecution.initialization.InstantExecutionProblemsListener;
import org.gradle.instantexecution.problems.DocumentationSection;
import org.gradle.instantexecution.problems.InstantExecutionProblems;
import org.gradle.instantexecution.problems.PropertyProblem;
import org.gradle.instantexecution.problems.PropertyProblemKt;
import org.gradle.instantexecution.problems.PropertyTrace;
import org.gradle.instantexecution.problems.StructuredMessage;
import org.gradle.internal.DisplayName;
import org.gradle.internal.InternalListener;
import org.gradle.util.Path;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gradle/instantexecution/initialization/DefaultInstantExecutionProblemsListener;", "Lorg/gradle/instantexecution/initialization/InstantExecutionProblemsListener;", "problems", "Lorg/gradle/instantexecution/problems/InstantExecutionProblems;", "userCodeApplicationContext", "Lorg/gradle/configuration/internal/UserCodeApplicationContext;", "(Lorg/gradle/instantexecution/problems/InstantExecutionProblems;Lorg/gradle/configuration/internal/UserCodeApplicationContext;)V", "listenerRegistrationProblem", "Lorg/gradle/instantexecution/problems/PropertyProblem;", "trace", "Lorg/gradle/instantexecution/problems/PropertyTrace;", "invocationDescription", "", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "onBuildScopeListenerRegistration", "", "listener", "", "invocationSource", "onProjectAccess", "task", "Lorg/gradle/api/internal/TaskInternal;", "onTaskDependenciesAccess", "onTaskExecutionAccessProblem", "taskExecutionAccessProblem", "gradle-instant-execution"})
public final class DefaultInstantExecutionProblemsListener
implements InstantExecutionProblemsListener {
    private final InstantExecutionProblems problems;
    private final UserCodeApplicationContext userCodeApplicationContext;

    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkParameterIsNotNull((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task) {
        Intrinsics.checkParameterIsNotNull((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task);
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task) {
        PropertyTrace propertyTrace;
        InvalidUserCodeException exception = new InvalidUserCodeException("Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported.");
        UserCodeApplicationContext.Application currentApplication = this.userCodeApplicationContext.current();
        if (currentApplication != null) {
            DisplayName displayName = currentApplication.getDisplayName();
            Intrinsics.checkExpressionValueIsNotNull((Object)displayName, (String)"currentApplication.displayName");
            propertyTrace = new PropertyTrace.BuildLogic(displayName);
        } else {
            Class clazz = GeneratedSubclasses.unpackType((Object)task);
            Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"GeneratedSubclasses.unpackType(task)");
            Path path = task.getIdentityPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"task.identityPath");
            String string2 = path.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"task.identityPath.path");
            propertyTrace = new PropertyTrace.Task(clazz, string2);
        }
        PropertyTrace location = propertyTrace;
        this.problems.onProblem(this.taskExecutionAccessProblem(location, invocationDescription, exception));
    }

    private final PropertyProblem taskExecutionAccessProblem(PropertyTrace trace, String invocationDescription, InvalidUserCodeException exception) {
        return new PropertyProblem(trace, StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkParameterIsNotNull((Object)$this$build, (String)"$receiver");
                $this$build.text("invocation of ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" at execution time is unsupported.");
            }
            {
                this.$invocationDescription = string2;
                super(1);
            }
        })), (Throwable)exception, DocumentationSection.RequirementsUseProjectDuringExecution);
    }

    public void onBuildScopeListenerRegistration(@NotNull Object listener, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkParameterIsNotNull((Object)invocationSource, (String)"invocationSource");
        if (!(listener instanceof InternalListener) && !(listener instanceof ProjectEvaluationListener)) {
            InvalidUserCodeException exception = new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.");
            this.problems.onProblem(this.listenerRegistrationProblem(PropertyProblemKt.location(this.userCodeApplicationContext, null), invocationDescription, exception));
        }
    }

    private final PropertyProblem listenerRegistrationProblem(PropertyTrace trace, String invocationDescription, InvalidUserCodeException exception) {
        return new PropertyProblem(trace, StructuredMessage.Companion.build((Function1<? super StructuredMessage.Builder, Unit>)((Function1)new Function1<StructuredMessage.Builder, Unit>(invocationDescription){
            final /* synthetic */ String $invocationDescription;

            public final void invoke(@NotNull StructuredMessage.Builder $this$build) {
                Intrinsics.checkParameterIsNotNull((Object)$this$build, (String)"$receiver");
                $this$build.text("registration of listener on ");
                $this$build.reference(this.$invocationDescription);
                $this$build.text(" is unsupported");
            }
            {
                this.$invocationDescription = string2;
                super(1);
            }
        })), (Throwable)exception, DocumentationSection.RequirementsBuildListeners);
    }

    public DefaultInstantExecutionProblemsListener(@NotNull InstantExecutionProblems problems, @NotNull UserCodeApplicationContext userCodeApplicationContext) {
        Intrinsics.checkParameterIsNotNull((Object)problems, (String)"problems");
        Intrinsics.checkParameterIsNotNull((Object)userCodeApplicationContext, (String)"userCodeApplicationContext");
        this.problems = problems;
        this.userCodeApplicationContext = userCodeApplicationContext;
    }
}

