/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import org.gradle.internal.execution.BeforeExecutionContext;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.impl.OutputsCleaner;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;

public class CleanupOutputsStep<C extends InputChangesContext, R extends Result>
implements Step<C, R> {
    private final Deleter deleter;
    private final OutputChangeListener outputChangeListener;
    private final Step<? super C, ? extends R> delegate;

    public CleanupOutputsStep(Deleter deleter, OutputChangeListener outputChangeListener, Step<? super C, ? extends R> delegate) {
        this.deleter = deleter;
        this.outputChangeListener = outputChangeListener;
        this.delegate = delegate;
    }

    @Override
    public R execute(C context) {
        UnitOfWork work;
        if (!context.isIncrementalExecution() && (work = context.getWork()).shouldCleanupOutputsOnNonIncrementalExecution()) {
            boolean hasOverlappingOutputs = context.getBeforeExecutionState().flatMap(BeforeExecutionState::getDetectedOverlappingOutputs).isPresent();
            if (hasOverlappingOutputs) {
                this.cleanupOverlappingOutputs((BeforeExecutionContext)context, work);
            } else {
                this.cleanupExclusiveOutputs(work);
            }
        }
        return this.delegate.execute(context);
    }

    private void cleanupOverlappingOutputs(BeforeExecutionContext context, UnitOfWork work) {
        context.getAfterPreviousExecutionState().ifPresent(previousOutputs -> {
            HashSet outputDirectoriesToPreserve = new HashSet();
            work.visitOutputProperties((name, type, root) -> {
                switch (type) {
                    case FILE: {
                        File parentFile = root.getParentFile();
                        if (parentFile == null) break;
                        outputDirectoriesToPreserve.add(parentFile);
                        break;
                    }
                    case DIRECTORY: {
                        outputDirectoriesToPreserve.add(root);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            });
            OutputsCleaner cleaner = new OutputsCleaner(this.deleter, file -> true, dir -> !outputDirectoriesToPreserve.contains(dir));
            for (FileCollectionFingerprint fileCollectionFingerprint : previousOutputs.getOutputFileProperties().values()) {
                try {
                    this.outputChangeListener.beforeOutputChange((Iterable<String>)fileCollectionFingerprint.getRootPaths());
                    cleaner.cleanupOutputs(fileCollectionFingerprint);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to clean up output files for " + work.getDisplayName(), e);
                }
            }
        });
    }

    private void cleanupExclusiveOutputs(UnitOfWork work) {
        work.visitOutputProperties((name, type, root) -> {
            if (root.exists()) {
                try {
                    switch (type) {
                        case FILE: {
                            this.deleter.delete(root);
                            break;
                        }
                        case DIRECTORY: {
                            this.deleter.ensureEmptyDirectory(root);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        });
    }
}

