/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.artifacts.MutableVariantFilesMetadata;
import org.gradle.api.artifacts.VariantFileMetadata;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultMutableVariantFilesMetadata;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.UrlBackedArtifactMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;

public class VariantFilesRules {
    private final List<VariantMetadataRules.VariantAction<? super MutableVariantFilesMetadata>> actions = Lists.newLinkedList();

    public void addFilesAction(VariantMetadataRules.VariantAction<? super MutableVariantFilesMetadata> action) {
        this.actions.add(action);
    }

    public <T extends ComponentVariant.File> ImmutableList<T> executeForFiles(VariantResolveMetadata variant, ImmutableList<T> declaredFiles, ModuleComponentIdentifier componentIdentifier) {
        DefaultMutableVariantFilesMetadata filesMetadata = this.execute(variant);
        if (filesMetadata.getFiles().isEmpty()) {
            return declaredFiles;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (!filesMetadata.isClearExistingFiles()) {
            builder.addAll(declaredFiles);
        }
        for (VariantFileMetadata file : filesMetadata.getFiles()) {
            builder.add((Object)((ComponentVariant.File)Cast.uncheckedNonnullCast((Object)new AbstractMutableModuleComponentResolveMetadata.FileImpl(file.getName(), file.getUrl()))));
        }
        return builder.build();
    }

    public <T extends ComponentArtifactMetadata> ImmutableList<T> executeForArtifacts(VariantResolveMetadata variant, ImmutableList<T> artifacts, ModuleComponentIdentifier componentIdentifier) {
        DefaultMutableVariantFilesMetadata filesMetadata = this.execute(variant);
        if (filesMetadata.getFiles().isEmpty()) {
            return artifacts;
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (!filesMetadata.isClearExistingFiles()) {
            for (ComponentArtifactMetadata existingArtifact : artifacts) {
                if (!this.isFilePathUnambiguous(existingArtifact)) continue;
                builder.add((Object)existingArtifact);
            }
        }
        for (VariantFileMetadata file : filesMetadata.getFiles()) {
            builder.add((Object)((ComponentArtifactMetadata)Cast.uncheckedNonnullCast((Object)new UrlBackedArtifactMetadata(componentIdentifier, file.getName(), file.getUrl()))));
        }
        return builder.build();
    }

    private DefaultMutableVariantFilesMetadata execute(VariantResolveMetadata variant) {
        DefaultMutableVariantFilesMetadata filesMetadata = new DefaultMutableVariantFilesMetadata();
        for (VariantMetadataRules.VariantAction<? super MutableVariantFilesMetadata> action : this.actions) {
            action.maybeExecute(variant, filesMetadata);
        }
        return filesMetadata;
    }

    private <T extends ComponentArtifactMetadata> boolean isFilePathUnambiguous(T existingArtifact) {
        return !(existingArtifact instanceof DefaultModuleComponentArtifactMetadata) || "jar".equals(existingArtifact.getName().getExtension());
    }
}

