/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.StandardProgressIndicator;

public class EmptyProgressIndicator
implements StandardProgressIndicator {
    @NotNull
    private final ModalityState myModalityState;
    @NotNull
    private volatile RunState myRunState;
    private volatile boolean myIsCanceled;
    private volatile int myNonCancelableSectionCount;

    public EmptyProgressIndicator() {
        this(ModalityState.defaultModalityState());
    }

    public EmptyProgressIndicator(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            EmptyProgressIndicator.$$$reportNull$$$0(0);
        }
        this.myRunState = RunState.VIRGIN;
        this.myModalityState = modalityState;
    }

    @Override
    public void start() {
        if (this.myRunState == RunState.STARTED) {
            throw new IllegalStateException("Indicator already started");
        }
        this.myRunState = RunState.STARTED;
        this.myIsCanceled = false;
    }

    @Override
    public void stop() {
        switch (this.myRunState) {
            case VIRGIN: {
                throw new IllegalStateException("Indicator can't be stopped because it wasn't started");
            }
            case STARTED: {
                this.myRunState = RunState.STOPPED;
                break;
            }
            case STOPPED: {
                throw new IllegalStateException("Indicator already stopped");
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.myRunState == RunState.STARTED;
    }

    @Override
    public final void cancel() {
        this.myIsCanceled = true;
        ProgressManager.canceled(this);
    }

    @Override
    public final boolean isCanceled() {
        return this.myIsCanceled;
    }

    @Override
    public final void checkCanceled() {
        if (this.myIsCanceled && this.myNonCancelableSectionCount == 0) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public void setText(String text2) {
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public void setText2(String text2) {
    }

    @Override
    public String getText2() {
        return "";
    }

    @Override
    public double getFraction() {
        return 1.0;
    }

    @Override
    public void setFraction(double fraction) {
    }

    @Override
    public void pushState() {
    }

    @Override
    public void popState() {
    }

    @Override
    public boolean isModal() {
        return false;
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = this.myModalityState;
        if (modalityState == null) {
            EmptyProgressIndicator.$$$reportNull$$$0(1);
        }
        return modalityState;
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/progress/EmptyProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/EmptyProgressIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum RunState {
        VIRGIN,
        STARTED,
        STOPPED;

    }
}

