/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.origin;

import java.io.File;
import java.util.Properties;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginMetadataFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OriginMetadataFactory.class);
    private static final String BUILD_INVOCATION_ID_KEY = "buildInvocationId";
    private static final String TYPE_KEY = "type";
    private static final String IDENTITY_KEY = "identity";
    private static final String CREATION_TIME_KEY = "creationTime";
    private static final String EXECUTION_TIME_KEY = "executionTime";
    private static final String ROOT_PATH_KEY = "rootPath";
    private static final String OPERATING_SYSTEM_KEY = "operatingSystem";
    private static final String HOST_NAME_KEY = "hostName";
    private static final String USER_NAME_KEY = "userName";
    private final File rootDir;
    private final String userName;
    private final String operatingSystem;
    private final String currentBuildInvocationId;
    private final PropertiesConfigurator additionalProperties;
    private final HostnameLookup hostnameLookup;

    public OriginMetadataFactory(File rootDir, String userName, String operatingSystem, String currentBuildInvocationId, PropertiesConfigurator additionalProperties, HostnameLookup hostnameLookup) {
        this.rootDir = rootDir;
        this.userName = userName;
        this.operatingSystem = operatingSystem;
        this.additionalProperties = additionalProperties;
        this.currentBuildInvocationId = currentBuildInvocationId;
        this.hostnameLookup = hostnameLookup;
    }

    public OriginWriter createWriter(CacheableEntity entry, long elapsedTime) {
        return outputStream -> {
            Properties properties = new Properties();
            properties.setProperty(BUILD_INVOCATION_ID_KEY, this.currentBuildInvocationId);
            properties.setProperty(TYPE_KEY, entry.getType().getCanonicalName());
            properties.setProperty(IDENTITY_KEY, entry.getIdentity());
            properties.setProperty(CREATION_TIME_KEY, Long.toString(System.currentTimeMillis()));
            properties.setProperty(EXECUTION_TIME_KEY, Long.toString(elapsedTime));
            properties.setProperty(ROOT_PATH_KEY, this.rootDir.getAbsolutePath());
            properties.setProperty(OPERATING_SYSTEM_KEY, this.operatingSystem);
            properties.setProperty(HOST_NAME_KEY, this.hostnameLookup.getHostname());
            properties.setProperty(USER_NAME_KEY, this.userName);
            this.additionalProperties.configure(properties);
            properties.store(outputStream, "Generated origin information");
        };
    }

    public OriginReader createReader(CacheableEntity entry) {
        return inputStream -> {
            Properties properties = new Properties();
            properties.load(inputStream);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Origin for {}: {}", (Object)entry.getDisplayName(), (Object)properties);
            }
            String originBuildInvocationId = properties.getProperty(BUILD_INVOCATION_ID_KEY);
            String executionTimeAsString = properties.getProperty(EXECUTION_TIME_KEY);
            if (originBuildInvocationId == null || executionTimeAsString == null) {
                throw new IllegalStateException("Cached result format error, corrupted origin metadata");
            }
            long originalExecutionTime = Long.parseLong(executionTimeAsString);
            return new OriginMetadata(originBuildInvocationId, originalExecutionTime);
        };
    }

    public static interface HostnameLookup {
        public String getHostname();
    }

    public static interface PropertiesConfigurator {
        public void configure(Properties var1);
    }
}

