/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import org.gradle.api.BuildCancelledException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;

public class CancelExecutionStep<C extends Context>
implements Step<C, Result> {
    private final BuildCancellationToken cancellationToken;
    private final Step<? super C, ? extends Result> delegate;

    public CancelExecutionStep(BuildCancellationToken cancellationToken, Step<? super C, ? extends Result> delegate) {
        this.cancellationToken = cancellationToken;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(UnitOfWork work, C context) {
        Thread thread = Thread.currentThread();
        Runnable interrupt = thread::interrupt;
        try {
            this.cancellationToken.addCallback(interrupt);
            Result result = this.delegate.execute(work, context);
            return result;
        }
        finally {
            this.cancellationToken.removeCallback(interrupt);
            if (this.cancellationToken.isCancellationRequested()) {
                Thread.interrupted();
                throw new BuildCancelledException("Build cancelled while executing " + work.getDisplayName());
            }
        }
    }
}

