/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.repository.internal.RemoteSnapshotMetadata;
import org.sonatype.aether.ConfigurationProperties;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.impl.MetadataGenerator;
import org.sonatype.aether.metadata.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteSnapshotMetadataGenerator
implements MetadataGenerator {
    private final Map<Object, RemoteSnapshotMetadata> snapshots;
    private final boolean legacyFormat;

    public RemoteSnapshotMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this.legacyFormat = ConfigurationProperties.get((Map)session.getConfigProperties(), (String)"maven.metadata.legacy", (boolean)false);
        this.snapshots = new LinkedHashMap<Object, RemoteSnapshotMetadata>();
        for (Metadata metadata : request.getMetadata()) {
            if (!(metadata instanceof RemoteSnapshotMetadata)) continue;
            RemoteSnapshotMetadata snapshotMetadata = (RemoteSnapshotMetadata)metadata;
            this.snapshots.put(snapshotMetadata.getKey(), snapshotMetadata);
        }
    }

    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!artifact.isSnapshot()) continue;
            Object key = RemoteSnapshotMetadata.getKey(artifact);
            RemoteSnapshotMetadata snapshotMetadata = this.snapshots.get(key);
            if (snapshotMetadata == null) {
                snapshotMetadata = new RemoteSnapshotMetadata(artifact, this.legacyFormat);
                this.snapshots.put(key, snapshotMetadata);
            }
            snapshotMetadata.bind(artifact);
        }
        return this.snapshots.values();
    }

    public Artifact transformArtifact(Artifact artifact) {
        Object key;
        RemoteSnapshotMetadata snapshotMetadata;
        if (artifact.isSnapshot() && artifact.getVersion().equals(artifact.getBaseVersion()) && (snapshotMetadata = this.snapshots.get(key = RemoteSnapshotMetadata.getKey(artifact))) != null) {
            artifact = artifact.setVersion(snapshotMetadata.getExpandedVersion(artifact));
        }
        return artifact;
    }

    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }
}

