/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import gnu.trove.THashMap;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.serialization.ClassUtil;
import org.jetbrains.kotlin.com.intellij.serialization.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NestedBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Serializer;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.MapAnnotation;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.XMap;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Element;

final class MapBinding
implements MultiNodeBinding,
NestedBinding {
    private static final Comparator<Object> KEY_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return c1.compareTo(c2);
        }
        return 0;
    };
    private final MapAnnotation oldAnnotation;
    private final XMap annotation;
    @NotNull
    private final Class<? extends Map> mapClass;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Binding keyBinding;
    private Binding valueBinding;
    private final MutableAccessor myAccessor;

    MapBinding(@Nullable MutableAccessor accessor, @NotNull Class<? extends Map> mapClass) {
        if (mapClass == null) {
            MapBinding.$$$reportNull$$$0(0);
        }
        this.myAccessor = accessor;
        this.oldAnnotation = accessor == null ? null : accessor.getAnnotation(MapAnnotation.class);
        this.annotation = accessor == null ? null : accessor.getAnnotation(XMap.class);
        this.mapClass = mapClass;
    }

    @Override
    @NotNull
    public MutableAccessor getAccessor() {
        MutableAccessor mutableAccessor = this.myAccessor;
        if (mutableAccessor == null) {
            MapBinding.$$$reportNull$$$0(1);
        }
        return mutableAccessor;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        if (originalType == null) {
            MapBinding.$$$reportNull$$$0(2);
        }
        if (serializer2 == null) {
            MapBinding.$$$reportNull$$$0(3);
        }
        ParameterizedType type2 = (ParameterizedType)originalType;
        Type[] typeArguments2 = type2.getActualTypeArguments();
        this.keyClass = ClassUtil.typeToClass(typeArguments2[0]);
        this.valueClass = ClassUtil.typeToClass(typeArguments2[1]);
        this.keyBinding = serializer2.getBinding(this.keyClass, typeArguments2[0]);
        this.valueBinding = serializer2.getBinding(this.valueClass, typeArguments2[1]);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    protected boolean isSurroundWithTag() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundWithTag();
    }

    @NotNull
    String getEntryElementName() {
        if (this.annotation != null) {
            String string2 = this.annotation.entryTagName();
            if (string2 == null) {
                MapBinding.$$$reportNull$$$0(5);
            }
            return string2;
        }
        String string3 = this.oldAnnotation == null ? "entry" : this.oldAnnotation.entryTagName();
        if (string3 == null) {
            MapBinding.$$$reportNull$$$0(6);
        }
        return string3;
    }

    private String getKeyAttributeName() {
        if (this.annotation != null) {
            return this.annotation.keyAttributeName();
        }
        return this.oldAnnotation == null ? "key" : this.oldAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        if (this.annotation != null) {
            return this.annotation.valueAttributeName();
        }
        return this.oldAnnotation == null ? "value" : this.oldAnnotation.valueAttributeName();
    }

    @Override
    @Nullable
    public Object deserializeList(@Nullable Object context2, @NotNull List<? extends Element> elements) {
        List<? extends Element> childNodes;
        if (elements == null) {
            MapBinding.$$$reportNull$$$0(7);
        }
        if (this.isSurroundWithTag()) {
            assert (elements.size() == 1);
            childNodes = elements.get(0).getChildren();
        } else {
            childNodes = elements;
        }
        return this.deserialize(context2, childNodes);
    }

    @Override
    public Object deserializeUnsafe(Object context2, @NotNull Element element) {
        if (element == null) {
            MapBinding.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    private Map deserialize(@Nullable Object context2, @NotNull List<? extends Element> childNodes) {
        Map map2;
        if (childNodes == null) {
            MapBinding.$$$reportNull$$$0(10);
        }
        Map map3 = map2 = this.myAccessor == null ? null : (Map)context2;
        if (map2 != null) {
            if (ClassUtil.isMutableMap(map2)) {
                map2.clear();
            } else {
                map2 = null;
            }
        }
        for (Element element : childNodes) {
            if (!element.getName().equals(this.getEntryElementName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + element);
                continue;
            }
            if (map2 == null) {
                if (this.mapClass == Map.class) {
                    map2 = new THashMap();
                } else {
                    try {
                        map2 = ReflectionUtil.newInstance(this.mapClass);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                        map2 = new THashMap();
                    }
                }
            }
            map2.put(this.deserializeKeyOrValue(element, this.getKeyAttributeName(), context2, this.keyBinding, this.keyClass), this.deserializeKeyOrValue(element, this.getValueAttributeName(), context2, this.valueBinding, this.valueClass));
        }
        return map2;
    }

    private Object deserializeKeyOrValue(@NotNull Element entry, @NotNull String attributeName, Object context2, @Nullable Binding binding, @NotNull Class<?> valueClass) {
        Attribute attribute;
        if (entry == null) {
            MapBinding.$$$reportNull$$$0(13);
        }
        if (attributeName == null) {
            MapBinding.$$$reportNull$$$0(14);
        }
        if (valueClass == null) {
            MapBinding.$$$reportNull$$$0(15);
        }
        if ((attribute = entry.getAttribute(attributeName)) != null) {
            return XmlSerializerImpl.convert(attribute.getValue(), valueClass);
        }
        if (!this.isSurroundKey()) {
            assert (binding != null);
            for (Element element : entry.getChildren()) {
                if (!binding.isBoundTo(element)) continue;
                return binding.deserializeUnsafe(context2, element);
            }
        } else {
            List<Object> children2;
            Element entryChild = entry.getChild(attributeName);
            List<Object> list2 = children2 = entryChild == null ? Collections.emptyList() : entryChild.getChildren();
            if (children2.isEmpty()) {
                return null;
            }
            assert (binding != null);
            return Binding.deserializeList(binding, null, children2);
        }
        return null;
    }

    private boolean isSurroundKey() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundKeyWithTag();
    }

    boolean isBoundToWithoutProperty(@NotNull Element element) {
        if (element == null) {
            MapBinding.$$$reportNull$$$0(16);
        }
        String elementName = element.getName();
        if (this.annotation != null) {
            return elementName.equals(this.annotation.entryTagName());
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return elementName.equals(this.oldAnnotation.entryTagName());
        }
        return elementName.equals("map");
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            MapBinding.$$$reportNull$$$0(17);
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return this.oldAnnotation.entryTagName().equals(element.getName());
        }
        if (this.annotation != null) {
            return this.annotation.propertyElementName().equals(element.getName());
        }
        return element.getName().equals("map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapClass";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/MapBinding";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNodes";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/MapBinding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serializeKeyOrValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deserializeKeyOrValue";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isBoundToWithoutProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

