/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import groovy.lang.GString;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.properties.InputPropertySpec;
import org.gradle.util.DeferredUtil;

public class InputParameterUtils {
    @Nullable
    public static Object prepareInputParameterValue(InputPropertySpec inputProperty, Task task) {
        String propertyName = inputProperty.getPropertyName();
        try {
            return InputParameterUtils.prepareInputParameterValue(inputProperty.getValue());
        }
        catch (Exception ex) {
            throw new InvalidUserDataException(String.format("Error while evaluating property '%s' of %s", propertyName, task), (Throwable)ex);
        }
    }

    @Nullable
    public static Object prepareInputParameterValue(@Nullable Object value) {
        Object unpacked = DeferredUtil.unpack((Object)value);
        return InputParameterUtils.finalizeValue(unpacked);
    }

    @Nullable
    private static Object finalizeValue(@Nullable Object unpacked) {
        if (unpacked instanceof GString) {
            return unpacked.toString();
        }
        if (unpacked instanceof FileCollection) {
            return ((FileCollection)unpacked).getFiles();
        }
        return unpacked;
    }
}

