/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.artifacts.transform.ExecuteScheduledTransformationStepBuildOperationDetails;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.execution.plan.Node;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.types.DefaultOperationDescriptor;
import org.gradle.internal.build.event.types.DefaultOperationFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultOperationStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTransformDescriptor;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.OperationDependenciesResolver;
import org.gradle.tooling.internal.provider.runner.OperationDependencyLookup;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;
import org.gradle.tooling.internal.provider.runner.SubtreeFilteringBuildOperationListener;

class ClientForwardingTransformOperationListener
extends SubtreeFilteringBuildOperationListener<ExecuteScheduledTransformationStepBuildOperationDetails>
implements OperationDependencyLookup {
    private final Map<TransformationNode, DefaultTransformDescriptor> descriptors = new ConcurrentHashMap<TransformationNode, DefaultTransformDescriptor>();
    private final OperationDependenciesResolver operationDependenciesResolver;

    ClientForwardingTransformOperationListener(ProgressEventConsumer eventConsumer, BuildEventSubscriptions clientSubscriptions, BuildOperationListener delegate, OperationDependenciesResolver operationDependenciesResolver) {
        super(eventConsumer, clientSubscriptions, delegate, OperationType.TRANSFORM, ExecuteScheduledTransformationStepBuildOperationDetails.class);
        this.operationDependenciesResolver = operationDependenciesResolver;
    }

    @Override
    public InternalOperationDescriptor lookupExistingOperationDescriptor(Node node) {
        if (this.isEnabled() && node instanceof TransformationNode) {
            return (InternalOperationDescriptor)this.descriptors.get(node);
        }
        return null;
    }

    @Override
    protected InternalOperationStartedProgressEvent toStartedEvent(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent, ExecuteScheduledTransformationStepBuildOperationDetails details) {
        return new DefaultOperationStartedProgressEvent(startEvent.getStartTime(), (DefaultOperationDescriptor)this.toTransformDescriptor(buildOperation, details));
    }

    @Override
    protected InternalOperationFinishedProgressEvent toFinishedEvent(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent, ExecuteScheduledTransformationStepBuildOperationDetails details) {
        return new DefaultOperationFinishedProgressEvent(finishEvent.getEndTime(), (DefaultOperationDescriptor)this.toTransformDescriptor(buildOperation, details), ClientForwardingBuildOperationListener.toOperationResult(finishEvent));
    }

    private DefaultTransformDescriptor toTransformDescriptor(BuildOperationDescriptor buildOperation, ExecuteScheduledTransformationStepBuildOperationDetails details) {
        return this.descriptors.computeIfAbsent(details.getTransformationNode(), transformationNode -> {
            OperationIdentifier id = buildOperation.getId();
            String displayName = buildOperation.getDisplayName();
            OperationIdentifier parentId = this.eventConsumer.findStartedParentId(buildOperation);
            String transformerName = details.getTransformerName();
            String subjectName = details.getSubjectName();
            Set<InternalOperationDescriptor> dependencies = this.operationDependenciesResolver.resolveDependencies((Node)transformationNode);
            return new DefaultTransformDescriptor((Object)id, displayName, (Object)parentId, transformerName, subjectName, dependencies);
        });
    }
}

