/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import javax.annotation.Nonnull;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.CallableBuildOperation;

public class ExecuteStep<C extends InputChangesContext>
implements Step<C, Result> {
    private final BuildOperationExecutor buildOperationExecutor;

    public ExecuteStep(BuildOperationExecutor buildOperationExecutor) {
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Result execute(final UnitOfWork work, final C context) {
        return (Result)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Result>(){

            public Result call(BuildOperationContext operationContext) {
                Result result = ExecuteStep.this.executeOperation(work, context);
                operationContext.setResult((Object)Operation.Result.INSTANCE);
                return result;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Executing " + work.getDisplayName())).details((Object)Operation.Details.INSTANCE);
            }
        });
    }

    @Nonnull
    private Result executeOperation(UnitOfWork work, C context) {
        try {
            Result.ExecutionResult executionResult = context.getInputChanges().map(inputChanges -> ExecuteStep.determineResult(work.execute((InputChangesInternal)inputChanges, (InputChangesContext)context), inputChanges.isIncremental())).orElseGet(() -> ExecuteStep.determineResult(work.execute(null, (InputChangesContext)context), false));
            return () -> Try.successful((Object)executionResult);
        }
        catch (Throwable t) {
            return () -> Try.failure((Throwable)t);
        }
    }

    private static Result.ExecutionResult determineResult(final UnitOfWork.WorkOutput workOutput, boolean incremental) {
        ExecutionOutcome outcome;
        switch (workOutput.getDidWork()) {
            case DID_NO_WORK: {
                outcome = ExecutionOutcome.UP_TO_DATE;
                break;
            }
            case DID_WORK: {
                outcome = incremental ? ExecutionOutcome.EXECUTED_INCREMENTALLY : ExecutionOutcome.EXECUTED_NON_INCREMENTALLY;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new Result.ExecutionResult(){

            @Override
            public ExecutionOutcome getOutcome() {
                return outcome;
            }

            @Override
            public Object getOutput() {
                return workOutput.getOutput();
            }
        };
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

