/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.GradlePropertiesController;
import org.gradle.initialization.ProjectSpec;
import org.gradle.initialization.ProjectSpecs;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.util.Path;

public class DefaultSettingsLoader
implements SettingsLoader {
    public static final String BUILD_SRC_PROJECT_PATH = ":buildSrc";
    private final SettingsProcessor settingsProcessor;
    private final BuildLayoutFactory buildLayoutFactory;
    private final GradlePropertiesController gradlePropertiesController;

    public DefaultSettingsLoader(SettingsProcessor settingsProcessor, BuildLayoutFactory buildLayoutFactory, GradlePropertiesController gradlePropertiesController) {
        this.settingsProcessor = settingsProcessor;
        this.buildLayoutFactory = buildLayoutFactory;
        this.gradlePropertiesController = gradlePropertiesController;
    }

    @Override
    public SettingsInternal findAndLoadSettings(GradleInternal gradle) {
        StartParameterInternal startParameter = gradle.getStartParameter();
        BuildLayout settingsLocation = this.buildLayoutFactory.getLayoutFor(new BuildLayoutConfiguration(startParameter));
        if (settingsLocation.isSettingsLoadedFromMasterDirectory()) {
            DeprecationLogger.deprecateBehaviour((String)"Searching for settings files in a directory named 'master' from a sibling directory has been deprecated.").willBeRemovedInGradle7().withUpgradeGuideSection(6, "master_subdirectory_root_build").nagUser();
        }
        this.loadGradlePropertiesFrom(settingsLocation);
        SettingsInternal settings = this.findSettingsAndLoadIfAppropriate(gradle, startParameter, settingsLocation, gradle.getClassLoaderScope());
        ProjectSpec spec = ProjectSpecs.forStartParameter(startParameter, settings);
        if (this.useEmptySettings(spec, settings, startParameter)) {
            settings = this.createEmptySettings(gradle, startParameter, settings.getClassLoaderScope());
        }
        this.setDefaultProject(spec, settings);
        return settings;
    }

    private void loadGradlePropertiesFrom(SettingsLocation settingsLocation) {
        this.gradlePropertiesController.loadGradlePropertiesFrom(settingsLocation.getSettingsDir());
    }

    private boolean useEmptySettings(ProjectSpec spec, SettingsInternal loadedSettings, StartParameter startParameter) {
        if (startParameter.getSettingsFile() != null) {
            return false;
        }
        if (spec.containsProject(loadedSettings.getProjectRegistry())) {
            return false;
        }
        return startParameter.getProjectDir() != null && loadedSettings.getSettingsDir().equals(startParameter.getProjectDir());
    }

    private SettingsInternal createEmptySettings(GradleInternal gradle, StartParameter startParameter, ClassLoaderScope classLoaderScope) {
        StartParameter noSearchParameter = startParameter.newInstance();
        ((StartParameterInternal)noSearchParameter).useEmptySettingsWithoutDeprecationWarning();
        BuildLayout layout = this.buildLayoutFactory.getLayoutFor(new BuildLayoutConfiguration(noSearchParameter));
        SettingsInternal settings = this.findSettingsAndLoadIfAppropriate(gradle, noSearchParameter, layout, classLoaderScope);
        if (noSearchParameter.getBuildFile() != null) {
            ProjectDescriptor rootProject = settings.getRootProject();
            rootProject.setBuildFileName(noSearchParameter.getBuildFile().getName());
        }
        return settings;
    }

    private void setDefaultProject(ProjectSpec spec, SettingsInternal settings) {
        settings.setDefaultProject(spec.selectProject(settings.getSettingsScript().getDisplayName(), settings.getProjectRegistry()));
    }

    private SettingsInternal findSettingsAndLoadIfAppropriate(GradleInternal gradle, StartParameter startParameter, SettingsLocation settingsLocation, ClassLoaderScope classLoaderScope) {
        SettingsInternal settings = this.settingsProcessor.process(gradle, settingsLocation, classLoaderScope, startParameter);
        this.validate(settings);
        return settings;
    }

    private void validate(SettingsInternal settings) {
        settings.getProjectRegistry().getAllProjects().forEach(project -> {
            if (project.getPath().equals(BUILD_SRC_PROJECT_PATH)) {
                Path buildPath = settings.getGradle().getIdentityPath();
                String suffix = buildPath == Path.ROOT ? "" : " (in build " + buildPath + ")";
                throw new GradleException("'buildSrc' cannot be used as a project name as it is a reserved name" + suffix);
            }
        });
    }
}

