/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.util.CollectionUtils;

public class AggregateTestResultsProvider
implements TestResultsProvider {
    private final Iterable<TestResultsProvider> providers;
    private Multimap<Long, DelegateProvider> classOutputProviders;

    public AggregateTestResultsProvider(Iterable<TestResultsProvider> providers) {
        this.providers = providers;
    }

    @Override
    public void visitClasses(Action<? super TestClassResult> visitor) {
        final LinkedHashMap aggregatedTestResults = new LinkedHashMap();
        this.classOutputProviders = ArrayListMultimap.create();
        final AtomicLong newIdCounter = new AtomicLong(0L);
        for (final TestResultsProvider provider : this.providers) {
            provider.visitClasses((Action<? super TestClassResult>)new Action<TestClassResult>(){

                public void execute(TestClassResult classResult) {
                    OverlaidIdProxyingTestClassResult newTestResult = (OverlaidIdProxyingTestClassResult)aggregatedTestResults.get(classResult.getClassName());
                    if (newTestResult != null) {
                        newTestResult.addTestClassResult(classResult);
                    } else {
                        long newId = newIdCounter.incrementAndGet();
                        newTestResult = new OverlaidIdProxyingTestClassResult(newId, classResult);
                        aggregatedTestResults.put(classResult.getClassName(), newTestResult);
                    }
                    AggregateTestResultsProvider.this.classOutputProviders.put((Object)newTestResult.getId(), (Object)new DelegateProvider(classResult.getId(), provider));
                }
            });
        }
        for (OverlaidIdProxyingTestClassResult classResult : aggregatedTestResults.values()) {
            visitor.execute((Object)classResult);
        }
    }

    @Override
    public boolean hasOutput(long classId, final TestOutputEvent.Destination destination) {
        return Iterables.any((Iterable)this.classOutputProviders.get((Object)classId), (Predicate)new Predicate<DelegateProvider>(){

            public boolean apply(DelegateProvider delegateProvider) {
                return delegateProvider.provider.hasOutput(delegateProvider.id, destination);
            }
        });
    }

    @Override
    public boolean hasOutput(long classId, final long testId, final TestOutputEvent.Destination destination) {
        return Iterables.any((Iterable)this.classOutputProviders.get((Object)classId), (Predicate)new Predicate<DelegateProvider>(){

            public boolean apply(DelegateProvider delegateProvider) {
                return delegateProvider.provider.hasOutput(delegateProvider.id, testId, destination);
            }
        });
    }

    @Override
    public void writeAllOutput(long classId, TestOutputEvent.Destination destination, Writer writer) {
        for (DelegateProvider delegateProvider : this.classOutputProviders.get((Object)classId)) {
            delegateProvider.provider.writeAllOutput(delegateProvider.id, destination, writer);
        }
    }

    @Override
    public boolean isHasResults() {
        return CollectionUtils.any(this.providers, (Spec)new Spec<TestResultsProvider>(){

            public boolean isSatisfiedBy(TestResultsProvider element) {
                return element.isHasResults();
            }
        });
    }

    @Override
    public void writeNonTestOutput(long classId, TestOutputEvent.Destination destination, Writer writer) {
        for (DelegateProvider delegateProvider : this.classOutputProviders.get((Object)classId)) {
            delegateProvider.provider.writeNonTestOutput(delegateProvider.id, destination, writer);
        }
    }

    @Override
    public void writeTestOutput(long classId, long testId, TestOutputEvent.Destination destination, Writer writer) {
        for (DelegateProvider delegateProvider : this.classOutputProviders.get((Object)classId)) {
            delegateProvider.provider.writeTestOutput(delegateProvider.id, testId, destination, writer);
        }
    }

    @Override
    public void close() throws IOException {
        CompositeStoppable.stoppable(this.providers).stop();
    }

    private static class OverlaidIdProxyingTestClassResult
    extends TestClassResult {
        private final Map<Long, TestClassResult> delegates = new LinkedHashMap<Long, TestClassResult>();

        public OverlaidIdProxyingTestClassResult(long id, TestClassResult delegate) {
            super(id, delegate.getClassName(), delegate.getStartTime());
            this.addTestClassResult(delegate);
        }

        void addTestClassResult(TestClassResult delegate) {
            Preconditions.checkArgument((this.delegates.isEmpty() || this.delegates.values().iterator().next().getClassName().equals(delegate.getClassName()) ? 1 : 0) != 0);
            this.delegates.put(delegate.getId(), delegate);
            for (TestMethodResult result : delegate.getResults()) {
                this.add(result);
            }
            if (delegate.getStartTime() < this.getStartTime()) {
                this.setStartTime(delegate.getStartTime());
            }
        }
    }

    private static class DelegateProvider {
        private final long id;
        private final TestResultsProvider provider;

        private DelegateProvider(long id, TestResultsProvider provider) {
            this.id = id;
            this.provider = provider;
        }
    }
}

