/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.List;
import org.gradle.api.file.Directory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.ModularizationOption;

public class InitSettings {
    private final BuildInitDsl dsl;
    private final String packageName;
    private final BuildInitTestFramework testFramework;
    private final String projectName;
    private final List<String> subprojects;
    private final ModularizationOption modularizationOption;
    private final Directory target;

    public InitSettings(String projectName, List<String> subprojects, ModularizationOption modularizationOption, BuildInitDsl dsl, String packageName, BuildInitTestFramework testFramework, Directory target) {
        this.projectName = projectName;
        this.subprojects = !subprojects.isEmpty() && modularizationOption == ModularizationOption.SINGLE_PROJECT ? Collections.singletonList(subprojects.get(0)) : subprojects;
        this.modularizationOption = modularizationOption;
        this.dsl = dsl;
        this.packageName = packageName;
        this.testFramework = testFramework;
        this.target = target;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<String> getSubprojects() {
        return this.subprojects;
    }

    public ModularizationOption getModularizationOption() {
        return this.modularizationOption;
    }

    public BuildInitDsl getDsl() {
        return this.dsl;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public BuildInitTestFramework getTestFramework() {
        return this.testFramework;
    }

    public Directory getTarget() {
        return this.target;
    }
}

