/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstructorInInterfaceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getChildren", "", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "hasPrimaryConstructor", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "report", "source", "checkers"})
public final class FirConstructorInInterfaceChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConstructorInInterfaceChecker INSTANCE;

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration2 instanceof FirClass) || ((FirClass)declaration2).getClassKind() != ClassKind.INTERFACE) {
            return;
        }
        FirSourceElement firSourceElement = declaration2.getSource();
        if (firSourceElement != null) {
            if (this.hasPrimaryConstructor(firSourceElement)) {
                this.report(reporter, declaration2.getSource());
            }
        }
    }

    private final boolean hasPrimaryConstructor(FirSourceElement $this$hasPrimaryConstructor) {
        PsiElement localPsi = FirSourceElementKt.getPsi($this$hasPrimaryConstructor);
        LighterASTNode localLightNode = FirSourceElementKt.getLightNode($this$hasPrimaryConstructor);
        if (localPsi != null && !(localPsi instanceof PsiErrorElement)) {
            return this.hasPrimaryConstructor(localPsi);
        }
        if (localLightNode != null && $this$hasPrimaryConstructor instanceof FirLightSourceElement) {
            return this.hasPrimaryConstructor(localLightNode, ((FirLightSourceElement)$this$hasPrimaryConstructor).getTree());
        }
        return false;
    }

    private final boolean hasPrimaryConstructor(PsiElement $this$hasPrimaryConstructor) {
        return !($this$hasPrimaryConstructor.getLastChild() instanceof PsiErrorElement) && $this$hasPrimaryConstructor.getLastChild() instanceof KtPrimaryConstructor;
    }

    private final boolean hasPrimaryConstructor(LighterASTNode $this$hasPrimaryConstructor, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        List<LighterASTNode> children2 = this.getChildren($this$hasPrimaryConstructor, tree);
        LighterASTNode lighterASTNode = (LighterASTNode)CollectionsKt.lastOrNull(children2);
        return Intrinsics.areEqual((Object)(lighterASTNode != null ? lighterASTNode.getTokenType() : null), (Object)KtNodeTypes.PRIMARY_CONSTRUCTOR);
    }

    private final List<LighterASTNode> getChildren(LighterASTNode $this$getChildren, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        List list2;
        Ref<T[]> children2 = new Ref<T[]>();
        int count = tree.getChildren($this$getChildren, children2);
        if (count > 0) {
            Object[] objectArray = children2.get();
            Intrinsics.checkNotNullExpressionValue(objectArray, (String)"children.get()");
            list2 = ArraysKt.filterNotNull((Object[])objectArray);
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getCONSTRUCTOR_IN_INTERFACE().on(it));
        }
    }

    private FirConstructorInInterfaceChecker() {
    }

    static {
        FirConstructorInInterfaceChecker firConstructorInInterfaceChecker;
        INSTANCE = firConstructorInInterfaceChecker = new FirConstructorInInterfaceChecker();
    }
}

