/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.kotlinx.collections.immutable.PersistentList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ0\u0010\u001e\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\u0006\u0010\u001f\u001a\u00020\t2\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0!J4\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\u00112\u0016\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0!J\u0012\u0010$\u001a\u00020\u00142\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0012\u0010&\u001a\u00020\u001b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u0005J \u0010'\u001a\u00020\u001b2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)R&\u0010\u0003\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0007\u001a2\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\bj\u0018\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RF\u0010\u0010\u001a:\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\bj\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00140\u0013j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "", "()V", "breakLoopsDfsVisited", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lkotlin/collections/HashSet;", "fileScopesMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/kotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopePersistentList;", "Lkotlin/collections/HashMap;", "newClassifiersForBreakingLoops", "", "scopesForNestedClassesMap", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "supertypeStatusMap", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationStatus;", "Lkotlin/collections/LinkedHashMap;", "supertypesSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "getSupertypesSupplier", "()Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "breakLoops", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getOrPutFileScope", "file", "scope", "Lkotlin/Function0;", "getOrPutScopeForNestedClasses", "klass", "getSupertypesComputationStatus", "classLikeDeclaration", "startComputingSupertypes", "storeSupertypes", "resolvedTypesRefs", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolve"})
final class SupertypeComputationSession {
    private final HashMap<FirFile, PersistentList<FirScope>> fileScopesMap;
    private final HashMap<FirClass<?>, PersistentList<FirScope>> scopesForNestedClassesMap;
    private final LinkedHashMap<FirClassLikeDeclaration<?>, SupertypeComputationStatus> supertypeStatusMap;
    private final SupertypeSupplier supertypesSupplier;
    private final List<FirClassLikeDeclaration<?>> newClassifiersForBreakingLoops;
    private final HashSet<FirClassLikeDeclaration<?>> breakLoopsDfsVisited;

    @NotNull
    public final SupertypeSupplier getSupertypesSupplier() {
        return this.supertypesSupplier;
    }

    @NotNull
    public final SupertypeComputationStatus getSupertypesComputationStatus(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, (String)"classLikeDeclaration");
        SupertypeComputationStatus supertypeComputationStatus = this.supertypeStatusMap.get(classLikeDeclaration);
        if (supertypeComputationStatus == null) {
            supertypeComputationStatus = SupertypeComputationStatus.NotComputed.INSTANCE;
        }
        return supertypeComputationStatus;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutFileScope(@NotNull FirFile file2, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map $this$getOrPut$iv = this.fileScopesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(file2);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(file2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForNestedClasses(@NotNull FirClass<?> klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter(scope2, (String)"scope");
        Map $this$getOrPut$iv = this.scopesForNestedClassesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(klass);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList answer$iv = (PersistentList)scope2.invoke();
            $this$getOrPut$iv.put(klass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    public final void startComputingSupertypes(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, (String)"classLikeDeclaration");
        boolean bl = this.supertypeStatusMap.get(classLikeDeclaration) == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unexpected in startComputingSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, SupertypeComputationStatus.Computing.INSTANCE);
    }

    public final void storeSupertypes(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration, @NotNull List<? extends FirTypeRef> resolvedTypesRefs) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, (String)"classLikeDeclaration");
        Intrinsics.checkNotNullParameter(resolvedTypesRefs, (String)"resolvedTypesRefs");
        boolean bl = this.supertypeStatusMap.get(classLikeDeclaration) instanceof SupertypeComputationStatus.Computing;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Unexpected in storeSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(resolvedTypesRefs));
        this.newClassifiersForBreakingLoops.add(classLikeDeclaration);
    }

    public final void breakLoops(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        boolean bl = false;
        HashSet inProcess = new HashSet();
        Function1 $fun$dfs$1 = new Function1<FirClassLikeDeclaration<?>, Unit>(this, inProcess, session2){
            final /* synthetic */ SupertypeComputationSession this$0;
            final /* synthetic */ HashSet $inProcess;
            final /* synthetic */ FirSession $session;

            public final void invoke(@NotNull FirClassLikeDeclaration<?> classLikeDeclaration) {
                Intrinsics.checkNotNullParameter(classLikeDeclaration, (String)"classLikeDeclaration");
                if (SupertypeComputationSession.access$getBreakLoopsDfsVisited$p(this.this$0).contains(classLikeDeclaration)) {
                    return;
                }
                SupertypeComputationStatus supertypeComputationStatus = (SupertypeComputationStatus)SupertypeComputationSession.access$getSupertypeStatusMap$p(this.this$0).get(classLikeDeclaration);
                if (supertypeComputationStatus == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)supertypeComputationStatus, (String)"supertypeStatusMap[classLikeDeclaration] ?: return");
                SupertypeComputationStatus supertypeComputationStatus2 = supertypeComputationStatus;
                if (this.$inProcess.contains(classLikeDeclaration)) {
                    return;
                }
                this.$inProcess.add(classLikeDeclaration);
                boolean bl = supertypeComputationStatus2 instanceof SupertypeComputationStatus.Computed;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string2 = "Expected computed supertypes in breakLoops for " + classLikeDeclaration.getSymbol().getClassId();
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                List<FirTypeRef> typeRefs = ((SupertypeComputationStatus.Computed)supertypeComputationStatus2).getSupertypeRefs();
                bl3 = false;
                List resultingTypeRefs = new ArrayList<E>();
                boolean wereChanges = false;
                for (FirTypeRef typeRef : typeRefs) {
                    FirTypeRef firTypeRef;
                    FirClassLikeDeclaration<?> fir = FirSupertypesResolutionKt.firClassLike(typeRef, this.$session);
                    if (fir != null) {
                        FirClassLikeDeclaration<?> firClassLikeDeclaration;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        FirClassLikeDeclaration<?> p1 = firClassLikeDeclaration;
                        boolean bl7 = false;
                        this.invoke(p1);
                    }
                    if (CollectionsKt.contains((Iterable)this.$inProcess, fir)) {
                        Object object;
                        wereChanges = true;
                        firTypeRef = FirSupertypesResolutionKt.access$createErrorTypeRef(typeRef, "Loop in supertype: " + classLikeDeclaration.getSymbol().getClassId() + " -> " + ((object = fir) != null && (object = object.getSymbol()) != null ? ((FirClassLikeSymbol)object).getClassId() : null));
                    } else {
                        firTypeRef = typeRef;
                    }
                    resultingTypeRefs.add(firTypeRef);
                }
                if (wereChanges) {
                    ((Map)SupertypeComputationSession.access$getSupertypeStatusMap$p(this.this$0)).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(resultingTypeRefs));
                }
                this.$inProcess.remove(classLikeDeclaration);
                SupertypeComputationSession.access$getBreakLoopsDfsVisited$p(this.this$0).add(classLikeDeclaration);
            }
            {
                this.this$0 = supertypeComputationSession;
                this.$inProcess = hashSet;
                this.$session = firSession;
                super(1);
            }
        };
        for (FirClassLikeDeclaration<?> classifier2 : this.newClassifiersForBreakingLoops) {
            $fun$dfs$1.invoke(classifier2);
        }
        this.newClassifiersForBreakingLoops.clear();
    }

    public SupertypeComputationSession() {
        boolean bl = false;
        this.fileScopesMap = new HashMap();
        bl = false;
        this.scopesForNestedClassesMap = new HashMap();
        bl = false;
        this.supertypeStatusMap = new LinkedHashMap();
        this.supertypesSupplier = new SupertypeSupplier(this){
            final /* synthetic */ SupertypeComputationSession this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<ConeClassLikeType> forClass(@NotNull FirClass<?> firClass) {
                List list2;
                Object object;
                Intrinsics.checkNotNullParameter(firClass, (String)"firClass");
                if (firClass.getResolvePhase().compareTo((Enum)FirResolvePhase.SUPER_TYPES) > 0) {
                    return FirDeclarationUtilKt.getSuperConeTypes(firClass);
                }
                SupertypeComputationStatus supertypeComputationStatus = this.this$0.getSupertypesComputationStatus((FirClassLikeDeclaration)firClass);
                if (!(supertypeComputationStatus instanceof SupertypeComputationStatus.Computed)) {
                    supertypeComputationStatus = null;
                }
                if ((object = (SupertypeComputationStatus.Computed)supertypeComputationStatus) != null && (object = ((SupertypeComputationStatus.Computed)object).getSupertypeRefs()) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        ConeClassLikeType coneClassLikeType;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        FirTypeRef it = (FirTypeRef)element$iv$iv;
                        boolean bl2 = false;
                        FirTypeRef $this$coneTypeSafe$iv = it;
                        boolean $i$f$coneTypeSafe = false;
                        boolean bl3 = false;
                        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                            firTypeRef = null;
                        }
                        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                        if (!(coneKotlinType instanceof ConeClassLikeType)) {
                            coneKotlinType = null;
                        }
                        if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        ConeClassLikeType it$iv$iv = coneClassLikeType;
                        boolean bl6 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = null;
                }
                List list3 = list2;
                boolean bl = false;
                List list4 = list3;
                if (list4 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                return list4;
            }

            @Nullable
            public ConeClassLikeType expansionForTypeAlias(@NotNull FirTypeAlias typeAlias) {
                ConeClassLikeType coneClassLikeType;
                Object object;
                Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
                if (typeAlias.getResolvePhase().compareTo((Enum)FirResolvePhase.SUPER_TYPES) > 0) {
                    return FirDeclarationUtilKt.getExpandedConeType(typeAlias);
                }
                SupertypeComputationStatus supertypeComputationStatus = this.this$0.getSupertypesComputationStatus(typeAlias);
                if (!(supertypeComputationStatus instanceof SupertypeComputationStatus.Computed)) {
                    supertypeComputationStatus = null;
                }
                if ((object = (SupertypeComputationStatus.Computed)supertypeComputationStatus) != null && (object = ((SupertypeComputationStatus.Computed)object).getSupertypeRefs()) != null && (object = (FirTypeRef)CollectionsKt.getOrNull((List)object, (int)0)) != null) {
                    Object $this$coneTypeSafe$iv = object;
                    boolean $i$f$coneTypeSafe = false;
                    boolean bl = false;
                    Object object2 = $this$coneTypeSafe$iv;
                    if (!(object2 instanceof FirResolvedTypeRef)) {
                        object2 = null;
                    }
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)object2;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
                } else {
                    coneClassLikeType = null;
                }
                return coneClassLikeType;
            }
            {
                this.this$0 = this$0;
            }
        };
        bl = false;
        this.newClassifiersForBreakingLoops = new ArrayList();
        bl = false;
        this.breakLoopsDfsVisited = new HashSet();
    }

    public static final /* synthetic */ HashSet access$getBreakLoopsDfsVisited$p(SupertypeComputationSession $this) {
        return $this.breakLoopsDfsVisited;
    }

    public static final /* synthetic */ LinkedHashMap access$getSupertypeStatusMap$p(SupertypeComputationSession $this) {
        return $this.supertypeStatusMap;
    }
}

