/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.typeEnhancement;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMapper;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancedTypeAnnotations;
import org.jetbrains.kotlin.load.java.typeEnhancement.EnhancementResult;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.MutabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeComponentPosition;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementKt$WhenMappings;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00040\u0005H\u0002\u001a\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\"\u0004\b\u0000\u0010\u000e*\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\"\u0004\b\u0000\u0010\u000e*\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\"\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007*\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\n\u0010\u0014\u001a\u00020\u0012*\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0012*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0007\"\u0004\b\u0000\u0010\u000e*\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\n\u0010\u0019\u001a\u00020\u0012*\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"ENHANCED_MUTABILITY_ANNOTATIONS", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancedTypeAnnotations;", "ENHANCED_NULLABILITY_ANNOTATIONS", "compositeAnnotationsOrSingle", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "", "enhanceMutability", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancementResult;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "qualifiers", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/JavaTypeQualifiers;", "position", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/TypeComponentPosition;", "enhancedMutability", "T", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/load/java/typeEnhancement/EnhancementResult;", "enhancedNullability", "getEnhancedNullability", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasEnhancedNullability", "Lorg/jetbrains/kotlin/types/TypeSystemCommonBackendContext;", "type", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "noChange", "shouldEnhance", "descriptors.jvm"})
public final class TypeEnhancementKt {
    private static final EnhancedTypeAnnotations ENHANCED_NULLABILITY_ANNOTATIONS;
    private static final EnhancedTypeAnnotations ENHANCED_MUTABILITY_ANNOTATIONS;

    public static final boolean hasEnhancedNullability(@NotNull KotlinType $this$hasEnhancedNullability) {
        Intrinsics.checkNotNullParameter((Object)$this$hasEnhancedNullability, (String)"$this$hasEnhancedNullability");
        return TypeEnhancementKt.hasEnhancedNullability(SimpleClassicTypeSystemContext.INSTANCE, $this$hasEnhancedNullability);
    }

    public static final boolean hasEnhancedNullability(@NotNull TypeSystemCommonBackendContext $this$hasEnhancedNullability, @NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)$this$hasEnhancedNullability, (String)"$this$hasEnhancedNullability");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        return $this$hasEnhancedNullability.hasAnnotation(type2, fqName2);
    }

    private static final Annotations compositeAnnotationsOrSingle(List<? extends Annotations> $this$compositeAnnotationsOrSingle) {
        Annotations annotations2;
        switch ($this$compositeAnnotationsOrSingle.size()) {
            case 0: {
                String string2 = "At least one Annotations object expected";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            case 1: {
                annotations2 = (Annotations)CollectionsKt.single($this$compositeAnnotationsOrSingle);
                break;
            }
            default: {
                annotations2 = new CompositeAnnotations(CollectionsKt.toList((Iterable)$this$compositeAnnotationsOrSingle));
            }
        }
        return annotations2;
    }

    public static final boolean shouldEnhance(@NotNull TypeComponentPosition $this$shouldEnhance) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$shouldEnhance), (String)"$this$shouldEnhance");
        return $this$shouldEnhance != TypeComponentPosition.INFLEXIBLE;
    }

    private static final <T> EnhancementResult<T> noChange(T $this$noChange) {
        return new EnhancementResult<T>($this$noChange, null);
    }

    private static final <T> EnhancementResult<T> enhancedNullability(T $this$enhancedNullability) {
        return new EnhancementResult<T>($this$enhancedNullability, ENHANCED_NULLABILITY_ANNOTATIONS);
    }

    private static final <T> EnhancementResult<T> enhancedMutability(T $this$enhancedMutability) {
        return new EnhancementResult<T>($this$enhancedMutability, ENHANCED_MUTABILITY_ANNOTATIONS);
    }

    private static final EnhancementResult<ClassifierDescriptor> enhanceMutability(ClassifierDescriptor $this$enhanceMutability, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($this$enhanceMutability);
        }
        if (!($this$enhanceMutability instanceof ClassDescriptor)) {
            return TypeEnhancementKt.noChange($this$enhanceMutability);
        }
        JavaToKotlinClassMapper mapper = JavaToKotlinClassMapper.INSTANCE;
        MutabilityQualifier mutabilityQualifier = qualifiers.getMutability();
        if (mutabilityQualifier != null) {
            switch (TypeEnhancementKt$WhenMappings.$EnumSwitchMapping$0[mutabilityQualifier.ordinal()]) {
                case 1: {
                    if (position != TypeComponentPosition.FLEXIBLE_LOWER || !mapper.isMutable((ClassDescriptor)$this$enhanceMutability)) break;
                    return TypeEnhancementKt.enhancedMutability(mapper.convertMutableToReadOnly((ClassDescriptor)$this$enhanceMutability));
                }
                case 2: {
                    if (position != TypeComponentPosition.FLEXIBLE_UPPER || !mapper.isReadOnly((ClassDescriptor)$this$enhanceMutability)) break;
                    return TypeEnhancementKt.enhancedMutability(mapper.convertReadOnlyToMutable((ClassDescriptor)$this$enhanceMutability));
                }
            }
        }
        return TypeEnhancementKt.noChange($this$enhanceMutability);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final EnhancementResult<Boolean> getEnhancedNullability(KotlinType $this$getEnhancedNullability, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        EnhancementResult<Boolean> enhancementResult2;
        if (!TypeEnhancementKt.shouldEnhance(position)) {
            return TypeEnhancementKt.noChange($this$getEnhancedNullability.isMarkedNullable());
        }
        NullabilityQualifier nullabilityQualifier = qualifiers.getNullability();
        if (nullabilityQualifier != null) {
            switch (TypeEnhancementKt$WhenMappings.$EnumSwitchMapping$1[nullabilityQualifier.ordinal()]) {
                case 1: {
                    enhancementResult2 = TypeEnhancementKt.enhancedNullability(true);
                    return enhancementResult2;
                }
                case 2: {
                    enhancementResult2 = TypeEnhancementKt.enhancedNullability(false);
                    return enhancementResult2;
                }
            }
        }
        enhancementResult2 = TypeEnhancementKt.noChange($this$getEnhancedNullability.isMarkedNullable());
        return enhancementResult2;
    }

    static {
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION");
        ENHANCED_NULLABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName2);
        FqName fqName3 = JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"JvmAnnotationNames.ENHANCED_MUTABILITY_ANNOTATION");
        ENHANCED_MUTABILITY_ANNOTATIONS = new EnhancedTypeAnnotations(fqName3);
    }

    public static final /* synthetic */ EnhancementResult access$enhanceMutability(ClassifierDescriptor $this$access_u24enhanceMutability, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        return TypeEnhancementKt.enhanceMutability($this$access_u24enhanceMutability, qualifiers, position);
    }

    public static final /* synthetic */ EnhancementResult access$getEnhancedNullability(KotlinType $this$access_u24getEnhancedNullability, JavaTypeQualifiers qualifiers, TypeComponentPosition position) {
        return TypeEnhancementKt.getEnhancedNullability($this$access_u24getEnhancedNullability, qualifiers, position);
    }

    public static final /* synthetic */ Annotations access$compositeAnnotationsOrSingle(List $this$access_u24compositeAnnotationsOrSingle) {
        return TypeEnhancementKt.compositeAnnotationsOrSingle($this$access_u24compositeAnnotationsOrSingle);
    }
}

