/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.util.GUtil;

public class SingleProjectTaskReportModel
implements TaskReportModel {
    private final SetMultimap<String, TaskDetails> groups;

    public static SingleProjectTaskReportModel forTasks(Collection<? extends Task> tasks, TaskDetailsFactory factory) {
        TreeMultimap groups = TreeMultimap.create(String::compareToIgnoreCase, Comparator.comparing(TaskDetails::getPath));
        for (Task task : tasks) {
            String group = GUtil.isTrue((Object)task.getGroup()) ? task.getGroup() : "";
            groups.put((Object)group, (Object)factory.create(task));
        }
        return new SingleProjectTaskReportModel((SetMultimap<String, TaskDetails>)groups);
    }

    private SingleProjectTaskReportModel(SetMultimap<String, TaskDetails> groups) {
        this.groups = groups;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        if (!this.groups.containsKey((Object)group)) {
            throw new IllegalArgumentException(String.format("Unknown group '%s'", group));
        }
        return this.groups.get((Object)group);
    }
}

