/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.changedetection.state.FileHasherStatistics;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.file.StatStatistics;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.VirtualFileSystemServices;
import org.gradle.internal.snapshot.impl.DirectorySnapshotterStatistics;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemWatchingBuildActionRunner
implements BuildActionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemWatchingBuildActionRunner.class);
    private final BuildActionRunner delegate;

    public FileSystemWatchingBuildActionRunner(BuildActionRunner delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        GradleInternal gradle = buildController.getGradle();
        StartParameterInternal startParameter = gradle.getStartParameter();
        ServiceRegistry services = gradle.getServices();
        BuildLifecycleAwareVirtualFileSystem virtualFileSystem = services.get(BuildLifecycleAwareVirtualFileSystem.class);
        StatStatistics.Collector statStatisticsCollector = services.get(StatStatistics.Collector.class);
        FileHasherStatistics.Collector fileHasherStatisticsCollector = services.get(FileHasherStatistics.Collector.class);
        DirectorySnapshotterStatistics.Collector directorySnapshotterStatisticsCollector = services.get(DirectorySnapshotterStatistics.Collector.class);
        BuildOperationRunner buildOperationRunner = services.get(BuildOperationRunner.class);
        boolean watchFileSystem = startParameter.isWatchFileSystem();
        BuildLifecycleAwareVirtualFileSystem.VfsLogging verboseVfsLogging = startParameter.isVfsVerboseLogging() ? BuildLifecycleAwareVirtualFileSystem.VfsLogging.VERBOSE : BuildLifecycleAwareVirtualFileSystem.VfsLogging.NORMAL;
        BuildLifecycleAwareVirtualFileSystem.WatchLogging debugWatchLogging = startParameter.isWatchFileSystemDebugLogging() ? BuildLifecycleAwareVirtualFileSystem.WatchLogging.DEBUG : BuildLifecycleAwareVirtualFileSystem.WatchLogging.NORMAL;
        FileSystemWatchingBuildActionRunner.logMessageForDeprecatedWatchFileSystemProperty(startParameter);
        FileSystemWatchingBuildActionRunner.logMessageForDeprecatedVfsRetentionProperty(startParameter);
        LOGGER.info("Watching the file system is {}", (Object)(watchFileSystem ? "enabled" : "disabled"));
        if (watchFileSystem) {
            FileSystemWatchingBuildActionRunner.dropVirtualFileSystemIfRequested(startParameter, virtualFileSystem);
        }
        if (verboseVfsLogging == BuildLifecycleAwareVirtualFileSystem.VfsLogging.VERBOSE) {
            FileSystemWatchingBuildActionRunner.logVfsStatistics("since last build", statStatisticsCollector, fileHasherStatisticsCollector, directorySnapshotterStatisticsCollector);
        }
        virtualFileSystem.afterBuildStarted(watchFileSystem, verboseVfsLogging, debugWatchLogging, buildOperationRunner);
        try {
            BuildActionRunner.Result result = this.delegate.run(action, buildController);
            return result;
        }
        finally {
            int maximumNumberOfWatchedHierarchies = VirtualFileSystemServices.getMaximumNumberOfWatchedHierarchies((StartParameter)startParameter);
            virtualFileSystem.beforeBuildFinished(watchFileSystem, verboseVfsLogging, debugWatchLogging, buildOperationRunner, maximumNumberOfWatchedHierarchies);
            if (verboseVfsLogging == BuildLifecycleAwareVirtualFileSystem.VfsLogging.VERBOSE) {
                FileSystemWatchingBuildActionRunner.logVfsStatistics("during current build", statStatisticsCollector, fileHasherStatisticsCollector, directorySnapshotterStatisticsCollector);
            }
        }
    }

    private static void logVfsStatistics(String title, StatStatistics.Collector statStatisticsCollector, FileHasherStatistics.Collector fileHasherStatisticsCollector, DirectorySnapshotterStatistics.Collector directorySnapshotterStatisticsCollector) {
        LOGGER.warn("VFS> Statistics {}:", (Object)title);
        LOGGER.warn("VFS> > Stat: {}", (Object)statStatisticsCollector.collect());
        LOGGER.warn("VFS> > FileHasher: {}", (Object)fileHasherStatisticsCollector.collect());
        LOGGER.warn("VFS> > DirectorySnapshotter: {}", (Object)directorySnapshotterStatisticsCollector.collect());
    }

    private static void dropVirtualFileSystemIfRequested(StartParameterInternal startParameter, BuildLifecycleAwareVirtualFileSystem virtualFileSystem) {
        if (VirtualFileSystemServices.isDropVfs((StartParameter)startParameter)) {
            virtualFileSystem.invalidateAll();
        }
    }

    private static void logMessageForDeprecatedWatchFileSystemProperty(StartParameterInternal startParameter) {
        if (startParameter.isWatchFileSystemUsingDeprecatedOption()) {
            String deprecatedWatchFsProperty = "org.gradle.unsafe.watch-fs";
            ((DeprecationMessageBuilder.DeprecateSystemProperty)DeprecationLogger.deprecateSystemProperty((String)deprecatedWatchFsProperty).replaceWith((Object)"org.gradle.vfs.watch")).willBeRemovedInGradle7().withUserManual("gradle_daemon").nagUser();
        }
    }

    private static void logMessageForDeprecatedVfsRetentionProperty(StartParameterInternal startParameter) {
        if (VirtualFileSystemServices.isDeprecatedVfsRetentionPropertyPresent((StartParameter)startParameter)) {
            String deprecatedVfsRetentionEnabledProperty = "org.gradle.unsafe.vfs.retention";
            DeprecationLogger.deprecateIndirectUsage((String)("Using the system property " + deprecatedVfsRetentionEnabledProperty + " to enable watching the file system")).withAdvice("Use the gradle property org.gradle.vfs.watch instead.").willBeRemovedInGradle7().withUserManual("gradle_daemon").nagUser();
        }
    }
}

