/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.file.DefaultFileHierarchySet;
import org.gradle.internal.file.FileHierarchySet;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchableHierarchies {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchableHierarchies.class);
    private final Predicate<String> watchFilter;
    private FileHierarchySet watchableHierarchies = DefaultFileHierarchySet.of();
    private final Deque<Path> recentlyUsedHierarchies = new ArrayDeque<Path>();

    public WatchableHierarchies(Predicate<String> watchFilter) {
        this.watchFilter = watchFilter;
    }

    public void registerWatchableHierarchy(File watchableHierarchy, SnapshotHierarchy root) {
        Path watchableHierarchyPath = watchableHierarchy.toPath().toAbsolutePath();
        String watchableHierarchyPathString = watchableHierarchyPath.toString();
        if (!this.watchFilter.test(watchableHierarchyPathString)) {
            throw new IllegalStateException(String.format("Unable to watch directory '%s' since it is within Gradle's caches", watchableHierarchyPathString));
        }
        if (!this.watchableHierarchies.contains(watchableHierarchyPathString)) {
            this.checkThatNothingExistsInNewWatchableHierarchy(watchableHierarchyPathString, root);
            this.recentlyUsedHierarchies.addFirst(watchableHierarchyPath);
            this.watchableHierarchies = this.watchableHierarchies.plus(watchableHierarchy);
        } else {
            this.recentlyUsedHierarchies.remove(watchableHierarchyPath);
            this.recentlyUsedHierarchies.addFirst(watchableHierarchyPath);
        }
        LOGGER.info("Now considering {} as hierarchies to watch", this.recentlyUsedHierarchies);
    }

    @CheckReturnValue
    public SnapshotHierarchy removeUnwatchedSnapshots(SnapshotHierarchy root, Invalidator invalidator) {
        RemoveUnwatchedFiles removeUnwatchedFilesVisitor = new RemoveUnwatchedFiles(root, invalidator);
        root.visitSnapshotRoots(snapshotRoot -> snapshotRoot.accept((FileSystemSnapshotHierarchyVisitor)removeUnwatchedFilesVisitor));
        return removeUnwatchedFilesVisitor.getRootWithUnwatchedFilesRemoved();
    }

    @CheckReturnValue
    public SnapshotHierarchy removeWatchedHierarchiesOverLimit(SnapshotHierarchy root, Predicate<Path> isWatchedHierarchy, int maximumNumberOfWatchedHierarchies, Invalidator invalidator) {
        this.recentlyUsedHierarchies.removeIf(hierarchy -> !isWatchedHierarchy.test((Path)hierarchy));
        SnapshotHierarchy result = root;
        int toRemove = this.recentlyUsedHierarchies.size() - maximumNumberOfWatchedHierarchies;
        if (toRemove > 0) {
            LOGGER.warn("Watching too many directories in the file system (watching {}, limit {}), dropping some state from the virtual file system", (Object)this.recentlyUsedHierarchies.size(), (Object)maximumNumberOfWatchedHierarchies);
            for (int i = 0; i < toRemove; ++i) {
                Path locationToRemove = this.recentlyUsedHierarchies.removeLast();
                result = invalidator.invalidate(locationToRemove.toString(), result);
            }
        }
        this.watchableHierarchies = DefaultFileHierarchySet.of(this.recentlyUsedHierarchies.stream().map(Path::toFile)::iterator);
        return result;
    }

    public Collection<Path> getWatchableHierarchies() {
        return this.recentlyUsedHierarchies;
    }

    private void checkThatNothingExistsInNewWatchableHierarchy(String watchableHierarchy, SnapshotHierarchy vfsRoot) {
        vfsRoot.visitSnapshotRoots(watchableHierarchy, snapshotRoot -> {
            if (!this.isInWatchableHierarchy(snapshotRoot.getAbsolutePath()) && !this.ignoredForWatching(snapshotRoot)) {
                throw new IllegalStateException(String.format("Found existing snapshot at '%s' for unwatched hierarchy '%s'", snapshotRoot.getAbsolutePath(), watchableHierarchy));
            }
        });
    }

    public boolean ignoredForWatching(FileSystemLocationSnapshot snapshot) {
        return snapshot.getAccessType() == FileMetadata.AccessType.VIA_SYMLINK || !this.watchFilter.test(snapshot.getAbsolutePath());
    }

    public boolean isInWatchableHierarchy(String path) {
        return this.watchableHierarchies.contains(path);
    }

    public boolean shouldWatch(FileSystemLocationSnapshot snapshot) {
        return !this.ignoredForWatching(snapshot) && this.isInWatchableHierarchy(snapshot.getAbsolutePath());
    }

    public static interface Invalidator {
        public SnapshotHierarchy invalidate(String var1, SnapshotHierarchy var2);
    }

    private class RemoveUnwatchedFiles
    implements FileSystemSnapshotHierarchyVisitor {
        private SnapshotHierarchy root;
        private final Invalidator invalidator;

        public RemoveUnwatchedFiles(SnapshotHierarchy root, Invalidator invalidator) {
            this.root = root;
            this.invalidator = invalidator;
        }

        public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
            if (this.shouldBeRemoved(snapshot)) {
                this.invalidateUnwatchedFile(snapshot);
                return SnapshotVisitResult.SKIP_SUBTREE;
            }
            return SnapshotVisitResult.CONTINUE;
        }

        private boolean shouldBeRemoved(FileSystemLocationSnapshot snapshot) {
            return snapshot.getAccessType() == FileMetadata.AccessType.VIA_SYMLINK || !WatchableHierarchies.this.isInWatchableHierarchy(snapshot.getAbsolutePath()) && WatchableHierarchies.this.watchFilter.test(snapshot.getAbsolutePath());
        }

        private void invalidateUnwatchedFile(FileSystemLocationSnapshot snapshot) {
            this.root = this.invalidator.invalidate(snapshot.getAbsolutePath(), this.root);
        }

        public SnapshotHierarchy getRootWithUnwatchedFilesRemoved() {
            return this.root;
        }
    }
}

