/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.text.DateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginLoadingResult;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginXmlFactory;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;

final class DescriptorListLoadingContext
implements AutoCloseable {
    static final boolean unitTestWithBundledPlugins = Boolean.getBoolean("idea.run.tests.with.bundled.plugins");
    private static final Logger LOG = PluginManagerCore.getLogger();
    @NotNull
    private final ExecutorService executorService;
    private final ConcurrentLinkedQueue<SafeJdomFactory[]> toDispose;
    private final Supplier<PluginXmlFactory> xmlFactorySupplier;
    @Nullable
    private final ThreadLocal<PluginXmlFactory[]> threadLocalXmlFactory;
    private final int maxThreads;
    @NotNull
    final PluginLoadingResult result;
    @NotNull
    final Set<PluginId> disabledPlugins;
    private volatile String defaultVersion;
    final boolean ignoreMissingInclude;
    final boolean skipDisabledPlugins;
    final boolean readConditionalConfigDirectlyIfPossible = false;
    boolean usePluginClassLoader;

    @NotNull
    public static DescriptorListLoadingContext createSingleDescriptorContext(@NotNull Set<PluginId> disabledPlugins) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(0);
        }
        return new DescriptorListLoadingContext(0, disabledPlugins, new PluginLoadingResult(Collections.emptyMap(), PluginManagerCore.getBuildNumber()));
    }

    DescriptorListLoadingContext(int flags, @NotNull Set<PluginId> disabledPlugins, @NotNull PluginLoadingResult result2) {
        if (disabledPlugins == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(2);
        }
        this.readConditionalConfigDirectlyIfPossible = false;
        this.usePluginClassLoader = !PluginManagerCore.isUnitTestMode || unitTestWithBundledPlugins;
        this.result = result2;
        this.disabledPlugins = disabledPlugins;
        this.ignoreMissingInclude = (flags & 2) == 2;
        this.skipDisabledPlugins = (flags & 4) == 4;
        int n = this.maxThreads = (flags & 1) == 1 ? Runtime.getRuntime().availableProcessors() - 1 : 1;
        if (this.maxThreads > 1) {
            this.executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor("PluginManager Loader", this.maxThreads, false);
            this.toDispose = new ConcurrentLinkedQueue();
            this.threadLocalXmlFactory = ThreadLocal.withInitial(() -> {
                PluginXmlFactory factory2 = new PluginXmlFactory();
                PluginXmlFactory[] ref = new PluginXmlFactory[]{factory2};
                this.toDispose.add(ref);
                return ref;
            });
            this.xmlFactorySupplier = () -> this.threadLocalXmlFactory.get()[0];
        } else {
            this.executorService = ConcurrencyUtil.newSameThreadExecutorService();
            this.toDispose = null;
            this.threadLocalXmlFactory = null;
            PluginXmlFactory factory2 = new PluginXmlFactory();
            this.xmlFactorySupplier = () -> factory2;
        }
    }

    @NotNull
    Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @NotNull
    SafeJdomFactory getXmlFactory() {
        SafeJdomFactory safeJdomFactory = this.xmlFactorySupplier.get();
        if (safeJdomFactory == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(5);
        }
        return safeJdomFactory;
    }

    @Override
    public void close() {
        if (this.threadLocalXmlFactory == null) {
            return;
        }
        if (this.maxThreads <= 1) {
            this.threadLocalXmlFactory.remove();
            return;
        }
        this.executorService.execute(() -> {
            for (SafeJdomFactory[] ref : this.toDispose) {
                ref[0] = null;
            }
        });
        this.executorService.shutdown();
    }

    @NotNull
    public Interner<String> getStringInterner() {
        Interner<String> interner = this.xmlFactorySupplier.get().stringInterner;
        if (interner == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(6);
        }
        return interner;
    }

    @NotNull
    public String getDefaultVersion() {
        String result2 = this.defaultVersion;
        if (result2 == null) {
            this.defaultVersion = result2 = this.result.productBuildNumber.asStringWithoutProductCode();
        }
        String string2 = result2;
        if (string2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    public DateFormat getDateParser() {
        DateFormat dateFormat = this.xmlFactorySupplier.get().releaseDateFormat;
        if (dateFormat == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(8);
        }
        return dateFormat;
    }

    @NotNull
    public List<String> getVisitedFiles() {
        List<String> list2 = this.xmlFactorySupplier.get().visitedFiles;
        if (list2 == null) {
            DescriptorListLoadingContext.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/DescriptorListLoadingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/DescriptorListLoadingContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringInterner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateParser";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisitedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSingleDescriptorContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

