/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.tasks.compile.BaseForkOptionsConverter;
import org.gradle.api.internal.tasks.compile.daemon.AbstractDaemonCompiler;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.api.tasks.scala.ScalaForkOptions;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.ClassLoaderStructure;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.HierarchicalClassLoaderStructure;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerFactory;

public class DaemonScalaCompiler<T extends ScalaJavaJointCompileSpec>
extends AbstractDaemonCompiler<T> {
    private final Class<? extends Compiler<T>> compilerClass;
    private final Object[] compilerConstructorArguments;
    private final Iterable<File> zincClasspath;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final File daemonWorkingDir;
    private final ClassPathRegistry classPathRegistry;
    private final ClassLoaderRegistry classLoaderRegistry;

    public DaemonScalaCompiler(File daemonWorkingDir, Class<? extends Compiler<T>> compilerClass, Object[] compilerConstructorArguments, WorkerDaemonFactory workerDaemonFactory, Iterable<File> zincClasspath, JavaForkOptionsFactory forkOptionsFactory, ClassPathRegistry classPathRegistry, ClassLoaderRegistry classLoaderRegistry, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        super((WorkerFactory)workerDaemonFactory, actionExecutionSpecFactory);
        this.compilerClass = compilerClass;
        this.compilerConstructorArguments = compilerConstructorArguments;
        this.zincClasspath = zincClasspath;
        this.forkOptionsFactory = forkOptionsFactory;
        this.daemonWorkingDir = daemonWorkingDir;
        this.classPathRegistry = classPathRegistry;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    protected AbstractDaemonCompiler.CompilerParameters getCompilerParameters(T spec) {
        return new ScalaCompilerParameters<T>(this.compilerClass.getName(), this.compilerConstructorArguments, spec);
    }

    protected DaemonForkOptions toDaemonForkOptions(T spec) {
        ForkOptions javaOptions = spec.getCompileOptions().getForkOptions();
        ScalaForkOptions scalaOptions = spec.getScalaCompileOptions().getForkOptions();
        JavaForkOptions javaForkOptions = new BaseForkOptionsConverter(this.forkOptionsFactory).transform(this.mergeForkOptions((BaseForkOptions)javaOptions, scalaOptions));
        javaForkOptions.setWorkingDir(this.daemonWorkingDir);
        String javaExecutable = javaOptions.getExecutable();
        if (javaExecutable != null) {
            javaForkOptions.setExecutable(javaExecutable);
        }
        ClassPath compilerClasspath = this.classPathRegistry.getClassPath("SCALA-COMPILER").plus(DefaultClassPath.of(this.zincClasspath));
        HierarchicalClassLoaderStructure classLoaderStructure = new HierarchicalClassLoaderStructure((ClassLoaderSpec)this.classLoaderRegistry.getGradleWorkerExtensionSpec()).withChild((ClassLoaderSpec)this.getScalaFilterSpec()).withChild((ClassLoaderSpec)new VisitableURLClassLoader.Spec("compiler", compilerClasspath.getAsURLs()));
        return new DaemonForkOptionsBuilder(this.forkOptionsFactory).javaForkOptions(javaForkOptions).withClassLoaderStructure((ClassLoaderStructure)classLoaderStructure).keepAliveMode(KeepAliveMode.SESSION).build();
    }

    private FilteringClassLoader.Spec getScalaFilterSpec() {
        FilteringClassLoader.Spec gradleApiAndScalaSpec = this.classLoaderRegistry.getGradleApiFilterSpec();
        gradleApiAndScalaSpec.disallowPackage("org.gradle.api.internal.tasks.scala");
        gradleApiAndScalaSpec.allowPackage("com.google");
        return gradleApiAndScalaSpec;
    }

    public static class ScalaCompilerParameters<T extends ScalaJavaJointCompileSpec>
    extends AbstractDaemonCompiler.CompilerParameters {
        private final T compileSpec;

        public ScalaCompilerParameters(String compilerClassName, Object[] compilerInstanceParameters, T compileSpec) {
            super(compilerClassName, compilerInstanceParameters);
            this.compileSpec = compileSpec;
        }

        public T getCompileSpec() {
            return this.compileSpec;
        }
    }
}

