/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.streams;

import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.operations.CurrentBuildOperationPreservingRunnable;
import org.gradle.process.internal.StreamsHandler;
import org.gradle.process.internal.streams.ExecOutputHandleRunner;

public class OutputStreamsForwarder
implements StreamsHandler {
    private final OutputStream standardOutput;
    private final OutputStream errorOutput;
    private final boolean readErrorStream;
    private final CountDownLatch completed;
    private Executor executor;
    private ExecOutputHandleRunner standardOutputReader;
    private ExecOutputHandleRunner standardErrorReader;

    public OutputStreamsForwarder(OutputStream standardOutput, OutputStream errorOutput, boolean readErrorStream) {
        this.standardOutput = standardOutput;
        this.errorOutput = errorOutput;
        this.readErrorStream = readErrorStream;
        this.completed = new CountDownLatch(readErrorStream ? 2 : 1);
    }

    public void connectStreams(Process process, String processName, Executor executor) {
        this.executor = executor;
        this.standardOutputReader = new ExecOutputHandleRunner("read standard output of " + processName, process.getInputStream(), this.standardOutput, this.completed);
        if (this.readErrorStream) {
            this.standardErrorReader = new ExecOutputHandleRunner("read error output of " + processName, process.getErrorStream(), this.errorOutput, this.completed);
        }
    }

    public void start() {
        if (this.readErrorStream) {
            this.executor.execute(this.wrapInBuildOperation(this.standardErrorReader));
        }
        this.executor.execute(this.wrapInBuildOperation(this.standardOutputReader));
    }

    private Runnable wrapInBuildOperation(Runnable runnable) {
        return new CurrentBuildOperationPreservingRunnable(runnable);
    }

    public void stop() {
        try {
            this.completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void disconnect() {
        this.standardOutputReader.disconnect();
        if (this.readErrorStream) {
            this.standardErrorReader.disconnect();
        }
    }
}

