/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.ide.visualstudio.internal.VisualStudioTargetBinary;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.nativeplatform.PreprocessingTool;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.toolchain.internal.MacroArgsConverter;
import org.gradle.util.CollectionUtils;
import org.gradle.util.VersionNumber;

public class NativeSpecVisualStudioTargetBinary
implements VisualStudioTargetBinary {
    private final NativeBinarySpecInternal binary;

    public NativeSpecVisualStudioTargetBinary(NativeBinarySpec binary) {
        this.binary = (NativeBinarySpecInternal)binary;
    }

    @Override
    public String getProjectPath() {
        return this.binary.getProjectPath();
    }

    @Override
    public String getComponentName() {
        return this.binary.getComponent().getName();
    }

    @Override
    public String getVisualStudioProjectName() {
        return NativeSpecVisualStudioTargetBinary.projectPrefix(this.getProjectPath()) + this.getComponentName() + this.getProjectType().getSuffix();
    }

    @Override
    public String getVisualStudioConfigurationName() {
        return NativeSpecVisualStudioTargetBinary.makeName(this.getVariantDimensions());
    }

    @Override
    public VersionNumber getVisualStudioVersion() {
        return VersionNumber.parse((String)"14.0");
    }

    @Override
    public VersionNumber getSdkVersion() {
        return VersionNumber.parse((String)"8.1");
    }

    @Override
    public FileCollection getSourceFiles() {
        Spec<LanguageSourceSet> filter = new Spec<LanguageSourceSet>(){

            public boolean isSatisfiedBy(LanguageSourceSet sourceSet) {
                return !(sourceSet instanceof WindowsResourceSet);
            }
        };
        Transformer<FileCollection, LanguageSourceSet> transform = new Transformer<FileCollection, LanguageSourceSet>(){

            public FileCollection transform(LanguageSourceSet sourceSet) {
                return sourceSet.getSource();
            }
        };
        return new LanguageSourceSetCollectionAdapter(this.getComponentName() + " source files", (Set<LanguageSourceSet>)this.binary.getInputs(), filter, transform);
    }

    @Override
    public FileCollection getResourceFiles() {
        Spec<LanguageSourceSet> filter = new Spec<LanguageSourceSet>(){

            public boolean isSatisfiedBy(LanguageSourceSet sourceSet) {
                return sourceSet instanceof WindowsResourceSet;
            }
        };
        Transformer<FileCollection, LanguageSourceSet> transform = new Transformer<FileCollection, LanguageSourceSet>(){

            public FileCollection transform(LanguageSourceSet sourceSet) {
                return sourceSet.getSource();
            }
        };
        return new LanguageSourceSetCollectionAdapter(this.getComponentName() + " resource files", (Set<LanguageSourceSet>)this.binary.getInputs(), filter, transform);
    }

    @Override
    public FileCollection getHeaderFiles() {
        Spec<LanguageSourceSet> filter = new Spec<LanguageSourceSet>(){

            public boolean isSatisfiedBy(LanguageSourceSet sourceSet) {
                return sourceSet instanceof HeaderExportingSourceSet;
            }
        };
        Transformer<FileCollection, LanguageSourceSet> transform = new Transformer<FileCollection, LanguageSourceSet>(){

            public FileCollection transform(LanguageSourceSet sourceSet) {
                HeaderExportingSourceSet exportingSourceSet = (HeaderExportingSourceSet)sourceSet;
                return exportingSourceSet.getExportedHeaders().plus((FileTree)exportingSourceSet.getImplicitHeaders());
            }
        };
        return new LanguageSourceSetCollectionAdapter(this.getComponentName() + " header files", (Set<LanguageSourceSet>)this.binary.getInputs(), filter, transform);
    }

    @Override
    public boolean isExecutable() {
        return this.binary instanceof NativeExecutableBinarySpec || this.binary instanceof NativeTestSuiteBinarySpec;
    }

    @Override
    public VisualStudioTargetBinary.ProjectType getProjectType() {
        return this.binary instanceof SharedLibraryBinarySpec ? VisualStudioTargetBinary.ProjectType.DLL : (this.binary instanceof StaticLibraryBinarySpec ? VisualStudioTargetBinary.ProjectType.LIB : (this.binary instanceof NativeExecutableBinarySpec ? VisualStudioTargetBinary.ProjectType.EXE : (this.binary instanceof NativeTestSuiteBinarySpec ? VisualStudioTargetBinary.ProjectType.EXE : VisualStudioTargetBinary.ProjectType.NONE)));
    }

    @Override
    public List<String> getVariantDimensions() {
        List dimensions = this.binary.getNamingScheme().getVariantDimensions();
        if (dimensions.isEmpty()) {
            return Lists.newArrayList((Object[])new String[]{this.binary.getBuildType().getName()});
        }
        return dimensions;
    }

    private InstallExecutable getInstallTask() {
        DomainObjectSet installTasks = this.binary.getTasks().withType(InstallExecutable.class);
        return installTasks.isEmpty() ? null : (InstallExecutable)installTasks.iterator().next();
    }

    @Override
    public String getBuildTaskPath() {
        if (this.isExecutable()) {
            return this.getInstallTask().getPath();
        }
        return this.binary.getTasks().getBuild().getPath();
    }

    @Override
    public String getCleanTaskPath() {
        return this.taskPath("clean");
    }

    private String taskPath(String taskName) {
        String projectPath = this.binary.getComponent().getProjectPath();
        if (":".equals(projectPath)) {
            return ":" + taskName;
        }
        return projectPath + ":" + taskName;
    }

    @Override
    public boolean isDebuggable() {
        return !"release".equals(this.binary.getBuildType().getName());
    }

    @Override
    public File getOutputFile() {
        if (this.isExecutable()) {
            InstallExecutable installTask = this.getInstallTask();
            return new File(((Directory)installTask.getInstallDirectory().get()).getAsFile(), "lib/" + ((RegularFile)installTask.getExecutableFile().get()).getAsFile().getName());
        }
        return this.binary.getPrimaryOutput();
    }

    @Override
    public List<String> getCompilerDefines() {
        ArrayList<String> defines = new ArrayList<String>();
        defines.addAll(this.getDefines("cCompiler"));
        defines.addAll(this.getDefines("cppCompiler"));
        defines.addAll(this.getDefines("rcCompiler"));
        return defines;
    }

    @Override
    public VisualStudioTargetBinary.LanguageStandard getLanguageStandard() {
        return VisualStudioTargetBinary.LanguageStandard.from(this.binary.getCppCompiler().getArgs());
    }

    private List<String> getDefines(String tool) {
        PreprocessingTool rcCompiler = this.findCompiler(tool);
        return rcCompiler == null ? Lists.newArrayList() : new MacroArgsConverter().transform(rcCompiler.getMacros());
    }

    private PreprocessingTool findCompiler(String tool) {
        return (PreprocessingTool)this.binary.getToolByName(tool);
    }

    @Override
    public Set<File> getIncludePaths() {
        LinkedHashSet<File> includes = new LinkedHashSet<File>();
        for (LanguageSourceSet sourceSet : this.binary.getInputs()) {
            if (!(sourceSet instanceof HeaderExportingSourceSet)) continue;
            includes.addAll(((HeaderExportingSourceSet)sourceSet).getExportedHeaders().getSrcDirs());
        }
        for (NativeDependencySet lib : this.binary.getLibs()) {
            includes.addAll(lib.getIncludeRoots().getFiles());
        }
        return includes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeSpecVisualStudioTargetBinary that = (NativeSpecVisualStudioTargetBinary)o;
        return this.binary.equals(that.binary);
    }

    public int hashCode() {
        return this.binary.hashCode();
    }

    static String projectPrefix(String projectPath) {
        if (":".equals(projectPath)) {
            return "";
        }
        return projectPath.substring(1).replace(":", "_") + "_";
    }

    private static String makeName(Iterable<String> components) {
        StringBuilder builder = new StringBuilder();
        for (String component : components) {
            if (component == null || component.length() <= 0) continue;
            if (builder.length() == 0) {
                builder.append(component);
                continue;
            }
            builder.append(StringUtils.capitalize((String)component));
        }
        return builder.toString();
    }

    private static class LanguageSourceSetCollectionAdapter
    extends CompositeFileCollection {
        private final String displayName;
        private final Set<LanguageSourceSet> inputs;
        private final Spec<LanguageSourceSet> filterSpec;
        private final Transformer<FileCollection, LanguageSourceSet> transformer;

        public LanguageSourceSetCollectionAdapter(String displayName, Set<LanguageSourceSet> inputs, Spec<LanguageSourceSet> filterSpec, Transformer<FileCollection, LanguageSourceSet> transformer) {
            this.displayName = displayName;
            this.inputs = inputs;
            this.filterSpec = filterSpec;
            this.transformer = transformer;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            for (LanguageSourceSet input : this.inputs) {
                context.add((Object)input);
            }
        }

        protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
            Set filtered = CollectionUtils.filter(this.inputs, this.filterSpec);
            for (LanguageSourceSet languageSourceSet : filtered) {
                visitor.accept((FileCollectionInternal)this.transformer.transform((Object)languageSourceSet));
            }
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

