/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.reflect.validation.DefaultPropertyValidationProblemBuilder;
import org.gradle.internal.reflect.validation.DefaultTypeValidationProblemBuilder;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.TypeProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;

public abstract class ProblemRecordingTypeValidationContext
implements TypeValidationContext {
    private final DocumentationRegistry documentationRegistry;
    private final Class<?> rootType;

    public ProblemRecordingTypeValidationContext(DocumentationRegistry documentationRegistry, @Nullable Class<?> rootType) {
        this.documentationRegistry = documentationRegistry;
        this.rootType = rootType;
    }

    @Override
    public void visitTypeProblem(Action<? super TypeProblemBuilder> problemSpec) {
        DefaultTypeValidationProblemBuilder builder = new DefaultTypeValidationProblemBuilder(this.documentationRegistry);
        problemSpec.execute((Object)builder);
        this.recordProblem(builder.build());
    }

    @Override
    public void visitPropertyProblem(Action<? super PropertyProblemBuilder> problemSpec) {
        DefaultPropertyValidationProblemBuilder builder = new DefaultPropertyValidationProblemBuilder(this.documentationRegistry);
        problemSpec.execute((Object)builder);
        builder.forType(this.rootType);
        this.recordProblem(builder.build());
    }

    protected abstract void recordProblem(TypeValidationProblem var1);
}

