/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DataClassDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class DataClassDeclarationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration2 instanceof KtClassOrObject)) {
            return;
        }
        if (((ClassDescriptor)descriptor2).isData()) {
            List<KtParameter> parameters2;
            KtPrimaryConstructor primaryConstructor2;
            Object object;
            if (((ClassDescriptor)descriptor2).getUnsubstitutedPrimaryConstructor() == null) {
                Object object2 = ((ClassDescriptor)descriptor2).getConstructors();
                Intrinsics.checkNotNullExpressionValue(object2, (String)"descriptor.constructors");
                boolean bl = false;
                if (!object2.isEmpty() && (object2 = ((KtClassOrObject)declaration2).getNameIdentifier()) != null) {
                    Object object3 = object2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it = object3;
                    boolean bl4 = false;
                    context2.getTrace().report(Errors.PRIMARY_CONSTRUCTOR_REQUIRED_FOR_DATA_CLASS.on((PsiElement)it));
                }
            }
            Object object4 = (object = (primaryConstructor2 = ((KtClassOrObject)declaration2).getPrimaryConstructor())) == null ? null : ((KtConstructor)object).getValueParameters();
            List<KtParameter> list2 = parameters2 = object4 == null ? CollectionsKt.emptyList() : object4;
            if (parameters2.isEmpty()) {
                KtPrimaryConstructor ktPrimaryConstructor = primaryConstructor2;
                object = ktPrimaryConstructor == null ? null : ktPrimaryConstructor.getValueParameterList();
                Object object5 = object4 = object == null ? ((KtClassOrObject)declaration2).getNameIdentifier() : (PsiElement)object;
                if (object4 != null) {
                    object = object4;
                    boolean bl = false;
                    boolean bl5 = false;
                    Object it = object;
                    boolean bl6 = false;
                    context2.getTrace().report(Errors.DATA_CLASS_WITHOUT_PARAMETERS.on((PsiElement)it));
                }
            }
            for (KtParameter parameter : parameters2) {
                if (parameter.isVarArg()) {
                    context2.getTrace().report(Errors.DATA_CLASS_VARARG_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
                if (parameter.hasValOrVar()) continue;
                context2.getTrace().report(Errors.DATA_CLASS_NOT_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
    }
}

