/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.util.Trie;
import org.objectweb.asm.commons.Remapper;

class ImplementationDependencyRelocator
extends Remapper {
    private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+)");
    private final Trie prefixes;
    private final List<String> mustRelocateList = Arrays.asList("com/sun/jna", "org/apache/groovy", "org/eclipse/jgit");

    private static Trie readPrefixes(RuntimeShadedJarType type) {
        final Trie.Builder builder = new Trie.Builder();
        IoActions.withResource((Closeable)ImplementationDependencyRelocator.class.getResourceAsStream(type.getIdentifier() + "-relocated.txt"), (Action)new ErroringAction<InputStream>(){

            protected void doExecute(InputStream thing) throws Exception {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(thing, Charset.forName("UTF-8")));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.startsWith("kotlin")) continue;
                    builder.addWord(line);
                }
            }
        });
        return builder.build();
    }

    public ImplementationDependencyRelocator(RuntimeShadedJarType type) {
        this.prefixes = ImplementationDependencyRelocator.readPrefixes(type);
    }

    public String map(String name) {
        String relocated;
        String value = name;
        String prefix = "";
        Matcher m = this.classPattern.matcher(name);
        if (m.matches()) {
            prefix = m.group(1) + "L";
            name = m.group(2);
        }
        if ((relocated = this.maybeRelocateResource(name)) == null) {
            return value;
        }
        return prefix.concat(relocated);
    }

    public String maybeRelocateResource(String resource) {
        if (this.prefixes.find((CharSequence)resource)) {
            return "org/gradle/internal/impldep/" + resource;
        }
        return null;
    }

    public boolean keepOriginalResource(String resource) {
        return resource == null || this.maybeRelocateResource(resource) == null || !this.mustBeRelocated(resource);
    }

    private final boolean mustBeRelocated(String resource) {
        for (String mustRelocate : this.mustRelocateList) {
            if (!resource.startsWith(mustRelocate)) continue;
            return true;
        }
        return false;
    }

    public ClassLiteralRemapping maybeRemap(String literal) {
        if (literal.startsWith("class$")) {
            String className = literal.substring(6).replace('$', '.');
            String replacement = this.maybeRelocateResource(className.replace('.', '/'));
            if (replacement == null) {
                return null;
            }
            String fieldNameReplacement = "class$" + replacement.replace('/', '$');
            return new ClassLiteralRemapping(className, replacement, fieldNameReplacement);
        }
        return null;
    }

    public static class ClassLiteralRemapping {
        private final String literal;
        private final String literalReplacement;
        private final String fieldNameReplacement;

        public ClassLiteralRemapping(String literal, String literalReplacement, String fieldNameReplacement) {
            this.literal = literal;
            this.literalReplacement = literalReplacement;
            this.fieldNameReplacement = fieldNameReplacement;
        }

        public String getLiteral() {
            return this.literal;
        }

        public String getLiteralReplacement() {
            return this.literalReplacement;
        }

        public String getFieldNameReplacement() {
            return this.fieldNameReplacement;
        }
    }
}

