/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Pair;
import kotlin.io.TextStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNumber;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilder;
import org.jetbrains.kotlin.js.util.TextOutput;

public class SourceMap3Builder
implements SourceMapBuilder {
    private final StringBuilder out = new StringBuilder(8192);
    private final File generatedFile;
    private final TextOutput textOutput;
    private final String pathPrefix;
    private final TObjectIntHashMap<SourceKey> sources = new TObjectIntHashMap<SourceKey>(){

        public int get(SourceKey key) {
            int index2 = this.index(key);
            return index2 < 0 ? -1 : this._values[index2];
        }
    };
    private final List<String> orderedSources = new ArrayList<String>();
    private final List<Supplier<Reader>> orderedSourceContentSuppliers = new ArrayList<Supplier<Reader>>();
    private int previousGeneratedColumn = -1;
    private int previousSourceIndex;
    private int previousSourceLine;
    private int previousSourceColumn;
    private int previousMappingOffset;
    private int previousPreviousSourceIndex;
    private int previousPreviousSourceLine;
    private int previousPreviousSourceColumn;
    private boolean currentMappingIsEmpty = true;

    public SourceMap3Builder(File generatedFile, TextOutput textOutput, String pathPrefix) {
        this.generatedFile = generatedFile;
        this.textOutput = textOutput;
        this.pathPrefix = pathPrefix;
    }

    @Override
    public File getOutFile() {
        return new File(this.generatedFile.getParentFile(), this.generatedFile.getName() + ".map");
    }

    @Override
    public String build() {
        JsonObject json = new JsonObject(new Pair[0]);
        json.getProperties().put("version", new JsonNumber(3.0));
        json.getProperties().put("file", new JsonString(this.generatedFile.getName()));
        this.appendSources(json);
        this.appendSourcesContent(json);
        json.getProperties().put("names", new JsonArray(new JsonNode[0]));
        json.getProperties().put("mappings", new JsonString(this.out.toString()));
        return json.toString();
    }

    private void appendSources(JsonObject json) {
        JsonArray array = new JsonArray(new JsonNode[0]);
        for (String source : this.orderedSources) {
            array.getElements().add(new JsonString(this.pathPrefix + source));
        }
        json.getProperties().put("sources", array);
    }

    private void appendSourcesContent(JsonObject json) {
        JsonArray array = new JsonArray(new JsonNode[0]);
        for (Supplier<Reader> contentSupplier : this.orderedSourceContentSuppliers) {
            Reader reader = contentSupplier.get();
            array.getElements().add(reader != null ? new JsonString(TextStreamsKt.readText((Reader)reader)) : JsonNull.INSTANCE);
        }
        json.getProperties().put("sourcesContent", array);
    }

    @Override
    public void newLine() {
        this.out.append(';');
        this.previousGeneratedColumn = -1;
    }

    @Override
    public void skipLinesAtBeginning(int count) {
        this.out.insert(0, StringUtil.repeatSymbol(';', count));
    }

    private int getSourceIndex(String source, Object identityObject, Supplier<Reader> contentSupplier) {
        SourceKey key = new SourceKey(source, identityObject);
        int sourceIndex = this.sources.get((Object)key);
        if (sourceIndex == -1) {
            sourceIndex = this.orderedSources.size();
            this.sources.put((Object)key, sourceIndex);
            this.orderedSources.add(source);
            this.orderedSourceContentSuppliers.add(contentSupplier);
        }
        return sourceIndex;
    }

    @Override
    public void addMapping(@NotNull String source, @Nullable Object identityObject, @NotNull Supplier<Reader> sourceContent, int sourceLine, int sourceColumn) {
        if (source == null) {
            SourceMap3Builder.$$$reportNull$$$1(0);
        }
        if (sourceContent == null) {
            SourceMap3Builder.$$$reportNull$$$1(1);
        }
        if (source == null) {
            SourceMap3Builder.$$$reportNull$$$0(0);
        }
        if (sourceContent == null) {
            SourceMap3Builder.$$$reportNull$$$0(1);
        }
        source = source.replace(File.separatorChar, '/');
        int sourceIndex = this.getSourceIndex(source, identityObject, sourceContent);
        if (!this.currentMappingIsEmpty && this.previousSourceIndex == sourceIndex && this.previousSourceLine == sourceLine && this.previousSourceColumn == sourceColumn) {
            return;
        }
        this.startMapping();
        Base64VLQ.encode(this.out, sourceIndex - this.previousSourceIndex);
        this.previousSourceIndex = sourceIndex;
        Base64VLQ.encode(this.out, sourceLine - this.previousSourceLine);
        this.previousSourceLine = sourceLine;
        Base64VLQ.encode(this.out, sourceColumn - this.previousSourceColumn);
        this.previousSourceColumn = sourceColumn;
        this.currentMappingIsEmpty = false;
    }

    @Override
    public void addEmptyMapping() {
        if (!this.currentMappingIsEmpty) {
            this.startMapping();
            this.currentMappingIsEmpty = true;
        }
    }

    private void startMapping() {
        boolean newGroupStarted;
        boolean bl = newGroupStarted = this.previousGeneratedColumn == -1;
        if (newGroupStarted) {
            this.previousGeneratedColumn = 0;
        }
        int columnDiff = this.textOutput.getColumn() - this.previousGeneratedColumn;
        if (!newGroupStarted) {
            this.out.append(',');
        }
        if (columnDiff > 0 || newGroupStarted) {
            Base64VLQ.encode(this.out, columnDiff);
            this.previousGeneratedColumn = this.textOutput.getColumn();
            this.previousMappingOffset = this.out.length();
            this.previousPreviousSourceIndex = this.previousSourceIndex;
            this.previousPreviousSourceLine = this.previousSourceLine;
            this.previousPreviousSourceColumn = this.previousSourceColumn;
        } else {
            this.out.setLength(this.previousMappingOffset);
            this.previousSourceIndex = this.previousPreviousSourceIndex;
            this.previousSourceLine = this.previousPreviousSourceLine;
            this.previousSourceColumn = this.previousPreviousSourceColumn;
        }
    }

    @Override
    public void addLink() {
        this.textOutput.print("\n//# sourceMappingURL=");
        this.textOutput.print(this.generatedFile.getName());
        this.textOutput.print(".map\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceContent";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/js/sourceMap/SourceMap3Builder";
        objectArray[2] = "addMapping";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "source";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceContent";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/js/sourceMap/SourceMap3Builder";
        objectArray[2] = "addMapping";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class SourceKey {
        private final String sourcePath;
        private final Object identityKey;

        SourceKey(String sourcePath, Object identityKey) {
            this.sourcePath = sourcePath;
            this.identityKey = identityKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SourceKey)) {
                return false;
            }
            SourceKey key = (SourceKey)o;
            if (!this.sourcePath.equals(key.sourcePath)) {
                return false;
            }
            return !(this.identityKey != null ? !this.identityKey.equals(key.identityKey) : key.identityKey != null);
        }

        public int hashCode() {
            int result2 = this.sourcePath.hashCode();
            result2 = 31 * result2 + (this.identityKey != null ? this.identityKey.hashCode() : 0);
            return result2;
        }
    }

    private static final class Base64VLQ {
        private static final char[] BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

        private Base64VLQ() {
        }

        private static int toVLQSigned(int value2) {
            return value2 < 0 ? (-value2 << 1) + 1 : value2 << 1;
        }

        public static void encode(StringBuilder out, int value2) {
            value2 = Base64VLQ.toVLQSigned(value2);
            do {
                int digit = value2 & 0x1F;
                if ((value2 >>>= 5) > 0) {
                    digit |= 0x20;
                }
                out.append(BASE64_MAP[digit]);
            } while (value2 > 0);
        }
    }
}

