/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.commons;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.org.objectweb.asm.Type;

public class Method {
    private final String name;
    private final String descriptor;
    private static final Map<String, String> PRIMITIVE_TYPE_DESCRIPTORS;

    public Method(String name, String descriptor2) {
        this.name = name;
        this.descriptor = descriptor2;
    }

    public Method(String name, Type returnType2, Type[] argumentTypes2) {
        this(name, Type.getMethodDescriptor(returnType2, argumentTypes2));
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Type getReturnType() {
        return Type.getReturnType(this.descriptor);
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.descriptor);
    }

    public String toString() {
        return this.name + this.descriptor;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Method)) {
            return false;
        }
        Method otherMethod = (Method)other;
        return this.name.equals(otherMethod.name) && this.descriptor.equals(otherMethod.descriptor);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.descriptor.hashCode();
    }

    static {
        HashMap<String, String> descriptors = new HashMap<String, String>();
        descriptors.put("void", "V");
        descriptors.put("byte", "B");
        descriptors.put("char", "C");
        descriptors.put("double", "D");
        descriptors.put("float", "F");
        descriptors.put("int", "I");
        descriptors.put("long", "J");
        descriptors.put("short", "S");
        descriptors.put("boolean", "Z");
        PRIMITIVE_TYPE_DESCRIPTORS = descriptors;
    }
}

