/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesHttpProxySettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesSecureHttpProxySettings;

public class S3ConnectionProperties {
    public static final String S3_ENDPOINT_PROPERTY = "org.gradle.s3.endpoint";
    public static final String S3_MAX_ERROR_RETRY = "org.gradle.s3.maxErrorRetry";
    private static final Set<String> SUPPORTED_SCHEMES = Sets.newHashSet((Object[])new String[]{"HTTP", "HTTPS"});
    private static final long DEFAULT_PART_SIZE = 0x3200000L;
    private final Optional<URI> endpoint;
    private final HttpProxySettings proxySettings;
    private final HttpProxySettings secureProxySettings;
    private final Optional<Integer> maxErrorRetryCount;
    private final long partSize;

    public S3ConnectionProperties() {
        this.endpoint = this.configureEndpoint(System.getProperty(S3_ENDPOINT_PROPERTY));
        this.proxySettings = new JavaSystemPropertiesHttpProxySettings();
        this.secureProxySettings = new JavaSystemPropertiesSecureHttpProxySettings();
        this.maxErrorRetryCount = this.configureErrorRetryCount(System.getProperty(S3_MAX_ERROR_RETRY));
        this.partSize = 0x3200000L;
    }

    public S3ConnectionProperties(HttpProxySettings proxySettings, HttpProxySettings secureProxySettings, URI endpoint, Integer maxErrorRetryCount) {
        this.endpoint = Optional.fromNullable((Object)endpoint);
        this.proxySettings = proxySettings;
        this.secureProxySettings = secureProxySettings;
        this.maxErrorRetryCount = Optional.fromNullable((Object)maxErrorRetryCount);
        this.partSize = 0x3200000L;
    }

    private Optional<URI> configureEndpoint(String property) {
        URI uri = null;
        if (StringUtils.isNotBlank((String)property)) {
            try {
                uri = new URI(property);
                if (StringUtils.isBlank((String)uri.getScheme()) || !SUPPORTED_SCHEMES.contains(uri.getScheme().toUpperCase())) {
                    throw new IllegalArgumentException("System property [org.gradle.s3.endpoint=" + property + "] must have a scheme of 'http' or 'https'");
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("System property [org.gradle.s3.endpoint=" + property + "]  must be a valid URI");
            }
        }
        return Optional.fromNullable(uri);
    }

    public Optional<URI> getEndpoint() {
        return this.endpoint;
    }

    public Optional<HttpProxySettings.HttpProxy> getProxy() {
        if (this.endpoint.isPresent()) {
            String host = ((URI)this.endpoint.get()).getHost();
            if (((URI)this.endpoint.get()).getScheme().toUpperCase().equals("HTTP")) {
                return Optional.fromNullable((Object)this.proxySettings.getProxy(host));
            }
            return Optional.fromNullable((Object)this.secureProxySettings.getProxy(host));
        }
        return Optional.fromNullable((Object)this.secureProxySettings.getProxy("s3.amazonaws.com"));
    }

    private Optional<Integer> configureErrorRetryCount(String property) {
        Integer count = null;
        if (null != property && (null == (count = Ints.tryParse((String)property)) || count < 0)) {
            throw new IllegalArgumentException("System property [org.gradle.s3.maxErrorRetry=" + property + "]  must be a valid positive Integer");
        }
        return Optional.fromNullable(count);
    }

    public Optional<Integer> getMaxErrorRetryCount() {
        return this.maxErrorRetryCount;
    }

    public long getPartSize() {
        return this.partSize;
    }

    public long getMultipartThreshold() {
        return this.partSize * 2L;
    }
}

