/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.internal.MutableBoolean;

public class OutputUnpacker
extends PropertyVisitor.Adapter {
    private final String ownerDisplayName;
    private final FileCollectionFactory fileCollectionFactory;
    private final boolean locationOnly;
    private final UnpackedOutputConsumer unpackedOutputConsumer;
    private final boolean finalizeBeforeUnpacking;
    private boolean hasDeclaredOutputs;

    public OutputUnpacker(String ownerDisplayName, FileCollectionFactory fileCollectionFactory, boolean locationOnly, boolean finalizeBeforeUnpacking, UnpackedOutputConsumer unpackedOutputConsumer) {
        this.ownerDisplayName = ownerDisplayName;
        this.fileCollectionFactory = fileCollectionFactory;
        this.locationOnly = locationOnly;
        this.finalizeBeforeUnpacking = finalizeBeforeUnpacking;
        this.unpackedOutputConsumer = unpackedOutputConsumer;
    }

    @Override
    public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
        this.hasDeclaredOutputs = true;
        MutableBoolean hasSpecs = new MutableBoolean();
        if (this.finalizeBeforeUnpacking) {
            value.maybeFinalizeValue();
        }
        FileParameterUtils.resolveOutputFilePropertySpecs(this.ownerDisplayName, propertyName, value, filePropertyType, this.fileCollectionFactory, this.locationOnly, spec -> {
            hasSpecs.set(true);
            this.unpackedOutputConsumer.visitUnpackedOutputFileProperty(propertyName, optional, value, (OutputFilePropertySpec)spec);
        });
        if (!hasSpecs.get()) {
            this.unpackedOutputConsumer.visitEmptyOutputFileProperty(propertyName, optional, value);
        }
    }

    public boolean hasDeclaredOutputs() {
        return this.hasDeclaredOutputs;
    }

    public static interface UnpackedOutputConsumer {
        public void visitUnpackedOutputFileProperty(String var1, boolean var2, PropertyValue var3, OutputFilePropertySpec var4);

        public void visitEmptyOutputFileProperty(String var1, boolean var2, PropertyValue var3);

        public static UnpackedOutputConsumer composite(final UnpackedOutputConsumer consumer1, final UnpackedOutputConsumer consumer2) {
            return new UnpackedOutputConsumer(){

                @Override
                public void visitUnpackedOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertySpec spec) {
                    consumer1.visitUnpackedOutputFileProperty(propertyName, optional, value, spec);
                    consumer2.visitUnpackedOutputFileProperty(propertyName, optional, value, spec);
                }

                @Override
                public void visitEmptyOutputFileProperty(String propertyName, boolean optional, PropertyValue value) {
                    consumer1.visitEmptyOutputFileProperty(propertyName, optional, value);
                    consumer2.visitEmptyOutputFileProperty(propertyName, optional, value);
                }
            };
        }
    }
}

