/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.internal.InternalBuildFinishedListener;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildModelController;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.DefaultBuildLifecycleController;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.scopes.BuildScopeListenerManagerAction;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.invocation.DefaultGradle;

public class DefaultBuildLifecycleControllerFactory
implements BuildLifecycleControllerFactory {
    @Override
    public BuildLifecycleController newInstance(BuildDefinition buildDefinition, BuildState owner, @Nullable GradleInternal parentModel, BuildScopeServices buildScopeServices) {
        File customBuildFile;
        StartParameterInternal startParameter = buildDefinition.getStartParameter();
        buildScopeServices.add(BuildDefinition.class, buildDefinition);
        buildScopeServices.add(BuildState.class, owner);
        buildScopeServices.addProvider(new GradleModelProvider(parentModel, startParameter));
        ListenerManager listenerManager = (ListenerManager)buildScopeServices.get(ListenerManager.class);
        for (Action action : buildScopeServices.getAll(BuildScopeListenerManagerAction.class)) {
            action.execute((Object)listenerManager);
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener((Object)usageLocationReporter);
        ShowStacktrace showStacktrace = startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled((boolean)false);
            }
        }
        DeprecationLogger.init((UsageLocationReporter)usageLocationReporter, (WarningMode)startParameter.getWarningMode(), (BuildOperationProgressEventEmitter)((BuildOperationProgressEventEmitter)buildScopeServices.get(BuildOperationProgressEventEmitter.class)));
        File customSettingsFile = startParameter.getSettingsFile();
        if (customSettingsFile != null) {
            DeprecationLogger.deprecateAction((String)"Specifying custom settings file location").willBeRemovedInGradle8().withUpgradeGuideSection(7, "configuring_custom_build_layout").nagUser();
        }
        if ((customBuildFile = startParameter.getBuildFile()) != null) {
            DeprecationLogger.deprecateAction((String)"Specifying custom build file location").willBeRemovedInGradle8().withUpgradeGuideSection(7, "configuring_custom_build_layout").nagUser();
        }
        GradleInternal gradle = (GradleInternal)buildScopeServices.get(GradleInternal.class);
        BuildModelController buildModelController = (BuildModelController)buildScopeServices.get(BuildModelController.class);
        return new DefaultBuildLifecycleController(gradle, buildModelController, (ExceptionAnalyser)buildScopeServices.get(ExceptionAnalyser.class), gradle.getBuildListenerBroadcaster(), (BuildCompletionListener)listenerManager.getBroadcaster(BuildCompletionListener.class), (InternalBuildFinishedListener)listenerManager.getBroadcaster(InternalBuildFinishedListener.class), (BuildWorkExecutor)gradle.getServices().get(BuildWorkExecutor.class), buildScopeServices);
    }

    private static class GradleModelProvider {
        @Nullable
        private final GradleInternal parentModel;
        private final StartParameter startParameter;

        private GradleModelProvider(@Nullable GradleInternal parentModel, StartParameter startParameter) {
            this.parentModel = parentModel;
            this.startParameter = startParameter;
        }

        GradleInternal createGradleModel(Instantiator instantiator, ServiceRegistryFactory serviceRegistryFactory) {
            return (GradleInternal)instantiator.newInstance(DefaultGradle.class, new Object[]{this.parentModel, this.startParameter, serviceRegistryFactory});
        }
    }
}

