/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.source;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.config.LoggingSourceSystem;
import org.gradle.internal.logging.config.LoggingSystem;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class JavaUtilLoggingSystem
implements LoggingSourceSystem {
    private static final Map<LogLevel, Level> LOG_LEVEL_MAPPING = new HashMap<LogLevel, Level>();
    private final Logger logger = Logger.getLogger("");
    private LogLevel requestedLevel;
    private boolean installed;

    @Override
    public LoggingSystem.Snapshot setLevel(LogLevel logLevel) {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        if (logLevel != this.requestedLevel) {
            this.requestedLevel = logLevel;
            if (this.installed) {
                this.logger.setLevel(LOG_LEVEL_MAPPING.get((Object)logLevel));
            }
        }
        return snapshot;
    }

    @Override
    public LoggingSystem.Snapshot startCapture() {
        LoggingSystem.Snapshot snapshot = this.snapshot();
        this.install(LOG_LEVEL_MAPPING.get((Object)this.requestedLevel));
        return snapshot;
    }

    @Override
    public void restore(LoggingSystem.Snapshot state) {
        SnapshotImpl snapshot = (SnapshotImpl)state;
        this.requestedLevel = snapshot.requestedLevel;
        if (snapshot.installed) {
            this.install(snapshot.javaUtilLevel);
        } else {
            this.uninstall(snapshot.javaUtilLevel);
        }
    }

    @Override
    public LoggingSystem.Snapshot snapshot() {
        return new SnapshotImpl(this.installed, this.logger.getLevel(), this.requestedLevel);
    }

    private void uninstall(Level level) {
        if (!this.installed) {
            return;
        }
        LogManager.getLogManager().reset();
        this.logger.setLevel(level);
        this.installed = false;
    }

    private void install(Level level) {
        if (!this.installed) {
            LogManager.getLogManager().reset();
            SLF4JBridgeHandler.install();
            this.installed = true;
        }
        this.logger.setLevel(level);
    }

    static {
        LOG_LEVEL_MAPPING.put(LogLevel.DEBUG, Level.FINE);
        LOG_LEVEL_MAPPING.put(LogLevel.INFO, Level.CONFIG);
        LOG_LEVEL_MAPPING.put(LogLevel.LIFECYCLE, Level.WARNING);
        LOG_LEVEL_MAPPING.put(LogLevel.WARN, Level.WARNING);
        LOG_LEVEL_MAPPING.put(LogLevel.QUIET, Level.SEVERE);
        LOG_LEVEL_MAPPING.put(LogLevel.ERROR, Level.SEVERE);
    }

    private static class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final boolean installed;
        private final Level javaUtilLevel;
        private final LogLevel requestedLevel;

        SnapshotImpl(boolean installed, Level javaUtilLevel, LogLevel requestedLevel) {
            this.installed = installed;
            this.javaUtilLevel = javaUtilLevel;
            this.requestedLevel = requestedLevel;
        }
    }
}

