/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.internal;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.configuration.internal.UserCodeApplicationId;
import org.gradle.internal.DisplayName;

public class DefaultUserCodeApplicationContext
implements UserCodeApplicationContext {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final ThreadLocal<CurrentApplication> currentApplication = new ThreadLocal();

    @Override
    @Nullable
    public UserCodeApplicationContext.Application current() {
        return this.currentApplication.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(DisplayName displayName, Action<? super UserCodeApplicationId> action) {
        CurrentApplication current = this.currentApplication.get();
        UserCodeApplicationId id = DefaultUserCodeApplicationContext.id();
        this.currentApplication.set(new CurrentApplication(id, displayName));
        try {
            action.execute((Object)id);
        }
        finally {
            this.currentApplication.set(current);
        }
    }

    @Override
    public <T> Action<T> reapplyCurrentLater(Action<T> action) {
        CurrentApplication current = this.currentApplication.get();
        if (current == null) {
            return action;
        }
        return current.reapplyLater(action);
    }

    private static UserCodeApplicationId id() {
        return new UserCodeApplicationId(COUNTER.incrementAndGet());
    }

    private class CurrentApplication
    implements UserCodeApplicationContext.Application {
        final UserCodeApplicationId id;
        final DisplayName displayName;

        public CurrentApplication(UserCodeApplicationId id, DisplayName displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        @Override
        public UserCodeApplicationId getId() {
            return this.id;
        }

        @Override
        public DisplayName getDisplayName() {
            return this.displayName;
        }

        @Override
        public void reapply(Runnable runnable) {
            CurrentApplication current = (CurrentApplication)DefaultUserCodeApplicationContext.this.currentApplication.get();
            DefaultUserCodeApplicationContext.this.currentApplication.set(this);
            try {
                runnable.run();
            }
            finally {
                DefaultUserCodeApplicationContext.this.currentApplication.set(current);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T reapply(Supplier<T> action) {
            CurrentApplication current = (CurrentApplication)DefaultUserCodeApplicationContext.this.currentApplication.get();
            DefaultUserCodeApplicationContext.this.currentApplication.set(this);
            try {
                T t = action.get();
                return t;
            }
            finally {
                DefaultUserCodeApplicationContext.this.currentApplication.set(current);
            }
        }

        @Override
        public <T> Action<T> reapplyLater(final Action<T> action) {
            return new Action<T>(){

                public void execute(T t) {
                    CurrentApplication current = (CurrentApplication)DefaultUserCodeApplicationContext.this.currentApplication.get();
                    DefaultUserCodeApplicationContext.this.currentApplication.set(CurrentApplication.this);
                    try {
                        action.execute(t);
                    }
                    finally {
                        DefaultUserCodeApplicationContext.this.currentApplication.set(current);
                    }
                }
            };
        }
    }
}

