/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Supplier;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.ValuedVfsHierarchy;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.collect.PersistentList;
import org.gradle.internal.file.Stat;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.EmptyChildMap;
import org.gradle.internal.snapshot.VfsRelativePath;

public class ExecutionNodeAccessHierarchy {
    private volatile ValuedVfsHierarchy<NodeAccess> root;
    private final Stat stat;

    public ExecutionNodeAccessHierarchy(CaseSensitivity caseSensitivity, Stat stat) {
        this.root = new ValuedVfsHierarchy(PersistentList.of(), EmptyChildMap.getInstance(), caseSensitivity);
        this.stat = stat;
    }

    public ImmutableSet<Node> getNodesAccessing(String location) {
        return this.visitValues(location, new AbstractNodeAccessVisitor(){

            @Override
            public void visitChildren(PersistentList<NodeAccess> values, Supplier<String> relativePathSupplier) {
                values.forEach(this::addNode);
            }
        });
    }

    public ImmutableSet<Node> getNodesAccessing(final String location, final Spec<FileTreeElement> filter) {
        return this.visitValues(location, new AbstractNodeAccessVisitor(){

            @Override
            public void visitChildren(PersistentList<NodeAccess> values, Supplier<String> relativePathSupplier) {
                String relativePathFromLocation = relativePathSupplier.get();
                if (ExecutionNodeAccessHierarchy.this.relativePathMatchesSpec((Spec<FileTreeElement>)filter, new File(location, relativePathFromLocation), relativePathFromLocation)) {
                    values.forEach(this::addNode);
                }
            }
        });
    }

    private boolean relativePathMatchesSpec(Spec<FileTreeElement> filter, File element, String relativePathString) {
        boolean elementIsFile = element.isFile();
        RelativePath relativePath = RelativePath.parse((boolean)elementIsFile, (String)relativePathString);
        if (!filter.isSatisfiedBy((Object)new ReadOnlyFileTreeElement(element, relativePath, this.stat))) {
            return false;
        }
        RelativePath parentRelativePath = relativePath.getParent();
        File parentFile = element.getParentFile();
        while (parentRelativePath != null && parentRelativePath != RelativePath.EMPTY_ROOT) {
            if (!filter.isSatisfiedBy((Object)new ReadOnlyFileTreeElement(parentFile, parentRelativePath, this.stat))) {
                return false;
            }
            parentRelativePath = parentRelativePath.getParent();
            parentFile = parentFile.getParentFile();
        }
        return true;
    }

    public synchronized void recordNodeAccessingLocations(Node node, Iterable<String> accessedLocations) {
        for (String location : accessedLocations) {
            VfsRelativePath relativePath = VfsRelativePath.of((String)location);
            this.root = this.root.recordValue(relativePath, new DefaultNodeAccess(node));
        }
    }

    public synchronized void recordNodeAccessingFileTree(Node node, String fileTreeRoot, Spec<FileTreeElement> filter) {
        VfsRelativePath relativePath = VfsRelativePath.of((String)fileTreeRoot);
        this.root = this.root.recordValue(relativePath, new FilteredNodeAccess(node, filter));
    }

    public synchronized void clear() {
        this.root = this.root.empty();
    }

    private ImmutableSet<Node> visitValues(String location, AbstractNodeAccessVisitor visitor) {
        VfsRelativePath relativePath = VfsRelativePath.of((String)location);
        if (relativePath.length() == 0) {
            this.root.visitAllValues(visitor);
        } else {
            this.root.visitValuesRelatedTo(relativePath, visitor);
        }
        return visitor.getResult();
    }

    private static class ReadOnlyFileTreeElement
    implements FileTreeElement {
        private final File file;
        private final RelativePath relativePath;
        private final Stat stat;

        public ReadOnlyFileTreeElement(File file, RelativePath relativePath, Stat stat) {
            this.file = file;
            this.relativePath = relativePath;
            this.stat = stat;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isDirectory() {
            return !this.relativePath.isFile();
        }

        public long getLastModified() {
            return this.file.lastModified();
        }

        public long getSize() {
            return this.file.length();
        }

        public InputStream open() {
            try {
                return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        public String getName() {
            return this.file.getName();
        }

        public String getPath() {
            return this.relativePath.getPathString();
        }

        public RelativePath getRelativePath() {
            return this.relativePath;
        }

        public int getMode() {
            return this.stat.getUnixMode(this.file);
        }
    }

    private class FilteredNodeAccess
    implements NodeAccess {
        private final Node node;
        private final Spec<FileTreeElement> spec;

        public FilteredNodeAccess(Node node, Spec<FileTreeElement> spec) {
            this.node = node;
            this.spec = spec;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public boolean accessesChild(VfsRelativePath childPath) {
            return ExecutionNodeAccessHierarchy.this.relativePathMatchesSpec((Spec<FileTreeElement>)this.spec, new File(childPath.getAbsolutePath()), childPath.getAsString());
        }
    }

    private static class DefaultNodeAccess
    implements NodeAccess {
        private final Node node;

        public DefaultNodeAccess(Node node) {
            this.node = node;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public boolean accessesChild(VfsRelativePath childPath) {
            return true;
        }
    }

    private static interface NodeAccess {
        public Node getNode();

        public boolean accessesChild(VfsRelativePath var1);
    }

    private static abstract class AbstractNodeAccessVisitor
    implements ValuedVfsHierarchy.ValueVisitor<NodeAccess> {
        private final ImmutableSet.Builder<Node> builder = ImmutableSet.builder();

        private AbstractNodeAccessVisitor() {
        }

        public void addNode(NodeAccess value) {
            this.builder.add((Object)value.getNode());
        }

        @Override
        public void visitExact(NodeAccess value) {
            this.addNode(value);
        }

        @Override
        public void visitAncestor(NodeAccess value, VfsRelativePath pathToVisitedLocation) {
            if (value.accessesChild(pathToVisitedLocation)) {
                this.addNode(value);
            }
        }

        public ImmutableSet<Node> getResult() {
            return this.builder.build();
        }
    }
}

