/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.DefaultIncludedBuildController;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.resources.ResourceLockCoordinationService;

class DefaultIncludedBuildControllers
implements Stoppable,
IncludedBuildControllers {
    private final Map<BuildIdentifier, IncludedBuildController> buildControllers = new HashMap<BuildIdentifier, IncludedBuildController>();
    private final ManagedExecutor executorService;
    private final ResourceLockCoordinationService coordinationService;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildStateRegistry buildRegistry;

    DefaultIncludedBuildControllers(ExecutorFactory executorFactory, BuildStateRegistry buildRegistry, ResourceLockCoordinationService coordinationService, ProjectStateRegistry projectStateRegistry) {
        this.buildRegistry = buildRegistry;
        this.executorService = executorFactory.create("included builds");
        this.coordinationService = coordinationService;
        this.projectStateRegistry = projectStateRegistry;
    }

    public IncludedBuildController getBuildController(BuildIdentifier buildId) {
        IncludedBuildController buildController = this.buildControllers.get(buildId);
        if (buildController != null) {
            return buildController;
        }
        IncludedBuildState build = this.buildRegistry.getIncludedBuild(buildId);
        DefaultIncludedBuildController newBuildController = new DefaultIncludedBuildController(build, this.coordinationService, this.projectStateRegistry);
        this.buildControllers.put(buildId, newBuildController);
        return newBuildController;
    }

    public void startTaskExecution() {
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            buildController.startTaskExecution((ExecutorService)this.executorService);
        }
    }

    public void populateTaskGraphs() {
        boolean tasksDiscovered = true;
        while (tasksDiscovered) {
            tasksDiscovered = false;
            for (IncludedBuildController buildController : ImmutableList.copyOf(this.buildControllers.values())) {
                if (!buildController.populateTaskGraph()) continue;
                tasksDiscovered = true;
            }
        }
    }

    public void awaitTaskCompletion(Consumer<? super Throwable> taskFailures) {
        for (IncludedBuildController buildController : this.buildControllers.values()) {
            buildController.awaitTaskCompletion(taskFailures);
        }
    }

    public void finishBuild(Consumer<? super Throwable> collector) {
        CompositeStoppable.stoppable(this.buildControllers.values()).stop();
        this.buildControllers.clear();
        for (IncludedBuildState includedBuild : this.buildRegistry.getIncludedBuilds()) {
            includedBuild.finishBuild(collector);
        }
    }

    public void stop() {
        CompositeStoppable.stoppable(this.buildControllers.values()).stop();
        this.executorService.stop();
    }
}

