/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.jvm.toolchain.internal.ToolchainSpecInternal;

public class DefaultToolchainSpec
implements ToolchainSpecInternal {
    private final Property<JavaLanguageVersion> languageVersion;
    private final Property<JvmVendorSpec> vendor;
    private final Property<JvmImplementation> implementation;

    @Inject
    public DefaultToolchainSpec(ObjectFactory factory) {
        this.languageVersion = factory.property(JavaLanguageVersion.class);
        this.vendor = factory.property(JvmVendorSpec.class).convention((Object)DefaultJvmVendorSpec.any());
        this.implementation = factory.property(JvmImplementation.class).convention((Object)JvmImplementation.VENDOR_SPECIFIC);
    }

    @Override
    public Property<JavaLanguageVersion> getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public Property<JvmVendorSpec> getVendor() {
        return this.vendor;
    }

    @Override
    public Property<JvmImplementation> getImplementation() {
        return this.implementation;
    }

    @Override
    public boolean isConfigured() {
        return this.languageVersion.isPresent();
    }

    public String getDisplayName() {
        MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((String)"");
        builder.omitNullValues();
        builder.add("languageVersion", this.languageVersion.map(JavaLanguageVersion::toString).getOrElse((Object)"unspecified"));
        builder.add("vendor", this.vendor.map(Object::toString).getOrNull());
        builder.add("implementation", this.implementation.map(JvmImplementation::toString).getOrNull());
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultToolchainSpec that = (DefaultToolchainSpec)o;
        return Objects.equal((Object)this.languageVersion.get(), (Object)that.languageVersion.get()) && Objects.equal((Object)this.vendor.get(), (Object)that.vendor.get()) && Objects.equal((Object)this.implementation.get(), (Object)that.implementation.get());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.languageVersion.get(), this.vendor.get(), this.implementation.get()});
    }
}

