/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.changedetection.state.FileHasherStatistics;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.file.StatStatistics;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.VirtualFileSystemServices;
import org.gradle.internal.snapshot.impl.DirectorySnapshotterStatistics;
import org.gradle.internal.watch.options.FileSystemWatchingSettingsFinalizedProgressDetails;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.internal.watch.vfs.VfsLogging;
import org.gradle.internal.watch.vfs.WatchLogging;
import org.gradle.internal.watch.vfs.WatchMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemWatchingBuildActionRunner
implements BuildActionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemWatchingBuildActionRunner.class);
    private final BuildOperationProgressEventEmitter eventEmitter;
    private final BuildActionRunner delegate;

    public FileSystemWatchingBuildActionRunner(BuildOperationProgressEventEmitter eventEmitter, BuildActionRunner delegate) {
        this.eventEmitter = eventEmitter;
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        GradleInternal gradle = buildController.getGradle();
        StartParameterInternal startParameter = gradle.getStartParameter();
        ServiceRegistry services = gradle.getServices();
        BuildLifecycleAwareVirtualFileSystem virtualFileSystem = services.get(BuildLifecycleAwareVirtualFileSystem.class);
        StatStatistics.Collector statStatisticsCollector = services.get(StatStatistics.Collector.class);
        FileHasherStatistics.Collector fileHasherStatisticsCollector = services.get(FileHasherStatistics.Collector.class);
        DirectorySnapshotterStatistics.Collector directorySnapshotterStatisticsCollector = services.get(DirectorySnapshotterStatistics.Collector.class);
        BuildOperationRunner buildOperationRunner = services.get(BuildOperationRunner.class);
        WatchMode watchFileSystemMode = startParameter.getWatchFileSystemMode();
        VfsLogging verboseVfsLogging = startParameter.isVfsVerboseLogging() ? VfsLogging.VERBOSE : VfsLogging.NORMAL;
        WatchLogging debugWatchLogging = startParameter.isWatchFileSystemDebugLogging() ? WatchLogging.DEBUG : WatchLogging.NORMAL;
        LOGGER.info("Watching the file system is {}", (Object)watchFileSystemMode.getDescription());
        if (watchFileSystemMode.isEnabled()) {
            FileSystemWatchingBuildActionRunner.dropVirtualFileSystemIfRequested(startParameter, virtualFileSystem);
        }
        if (verboseVfsLogging == VfsLogging.VERBOSE) {
            FileSystemWatchingBuildActionRunner.logVfsStatistics("since last build", statStatisticsCollector, fileHasherStatisticsCollector, directorySnapshotterStatisticsCollector);
        }
        final boolean actuallyWatching = virtualFileSystem.afterBuildStarted(watchFileSystemMode, verboseVfsLogging, debugWatchLogging, buildOperationRunner);
        this.eventEmitter.emitNowForCurrent(new FileSystemWatchingSettingsFinalizedProgressDetails(){

            public boolean isEnabled() {
                return actuallyWatching;
            }
        });
        try {
            BuildActionRunner.Result result = this.delegate.run(action, buildController);
            return result;
        }
        finally {
            int maximumNumberOfWatchedHierarchies = VirtualFileSystemServices.getMaximumNumberOfWatchedHierarchies((StartParameter)startParameter);
            virtualFileSystem.beforeBuildFinished(watchFileSystemMode, verboseVfsLogging, debugWatchLogging, buildOperationRunner, maximumNumberOfWatchedHierarchies);
            if (verboseVfsLogging == VfsLogging.VERBOSE) {
                FileSystemWatchingBuildActionRunner.logVfsStatistics("during current build", statStatisticsCollector, fileHasherStatisticsCollector, directorySnapshotterStatisticsCollector);
            }
        }
    }

    private static void logVfsStatistics(String title, StatStatistics.Collector statStatisticsCollector, FileHasherStatistics.Collector fileHasherStatisticsCollector, DirectorySnapshotterStatistics.Collector directorySnapshotterStatisticsCollector) {
        LOGGER.warn("VFS> Statistics {}:", (Object)title);
        LOGGER.warn("VFS> > Stat: {}", (Object)statStatisticsCollector.collect());
        LOGGER.warn("VFS> > FileHasher: {}", (Object)fileHasherStatisticsCollector.collect());
        LOGGER.warn("VFS> > DirectorySnapshotter: {}", (Object)directorySnapshotterStatisticsCollector.collect());
    }

    private static void dropVirtualFileSystemIfRequested(StartParameterInternal startParameter, BuildLifecycleAwareVirtualFileSystem virtualFileSystem) {
        if (VirtualFileSystemServices.isDropVfs((StartParameter)startParameter)) {
            virtualFileSystem.invalidateAll();
        }
    }
}

