/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ExternalResourceCachePolicy;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.cached.CachedExternalResource;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaDataCompare;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.util.internal.BuildCommencedTimeProvider;
import org.gradle.util.internal.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheAwareExternalResourceAccessor
implements CacheAwareExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheAwareExternalResourceAccessor.class);
    private final ExternalResourceRepository delegate;
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;
    private final BuildCommencedTimeProvider timeProvider;
    private final TemporaryFileProvider temporaryFileProvider;
    private final ArtifactCacheLockingManager artifactCacheLockingManager;
    private final ExternalResourceCachePolicy externalResourceCachePolicy;
    private final ProducerGuard<ExternalResourceName> producerGuard;
    private final FileResourceRepository fileResourceRepository;
    private final ChecksumService checksumService;

    public DefaultCacheAwareExternalResourceAccessor(ExternalResourceRepository delegate, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, TemporaryFileProvider temporaryFileProvider, ArtifactCacheLockingManager artifactCacheLockingManager, ExternalResourceCachePolicy externalResourceCachePolicy, ProducerGuard<ExternalResourceName> producerGuard, FileResourceRepository fileResourceRepository, ChecksumService checksumService) {
        this.delegate = delegate;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
        this.timeProvider = timeProvider;
        this.temporaryFileProvider = temporaryFileProvider;
        this.artifactCacheLockingManager = artifactCacheLockingManager;
        this.externalResourceCachePolicy = externalResourceCachePolicy;
        this.producerGuard = producerGuard;
        this.fileResourceRepository = fileResourceRepository;
        this.checksumService = checksumService;
    }

    @Override
    @Nullable
    public LocallyAvailableExternalResource getResource(ExternalResourceName location, @Nullable String baseName, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, @Nullable LocallyAvailableResourceCandidates additionalCandidates) {
        return (LocallyAvailableExternalResource)this.producerGuard.guardByKey((Object)location, () -> {
            boolean hasLocalCandidates;
            boolean isUnchanged;
            LOGGER.debug("Constructing external resource: {}", (Object)location);
            CachedExternalResource cached = this.cachedExternalResourceIndex.lookup(location.toString());
            if (cached == null && (additionalCandidates == null || additionalCandidates.isNone())) {
                return this.copyToCache(location, fileStore, this.delegate.withProgressLogging().resource(location));
            }
            if (cached != null && !this.externalResourceCachePolicy.mustRefreshExternalResource(this.getAgeMillis(this.timeProvider, cached))) {
                return this.fileResourceRepository.resource(cached.getCachedFile(), location.getUri(), cached.getExternalResourceMetaData());
            }
            boolean revalidate = true;
            ExternalResourceMetaData remoteMetaData = this.delegate.resource(location, true).getMetaData();
            if (remoteMetaData == null) {
                return null;
            }
            if (cached != null && (isUnchanged = ExternalResourceMetaDataCompare.isDefinitelyUnchanged((ExternalResourceMetaData)cached.getExternalResourceMetaData(), () -> remoteMetaData))) {
                LOGGER.info("Cached resource {} is up-to-date (lastModified: {}).", (Object)location, (Object)cached.getExternalLastModified());
                this.cachedExternalResourceIndex.store(location.toString(), cached.getCachedFile(), cached.getExternalResourceMetaData());
                return this.fileResourceRepository.resource(cached.getCachedFile(), location.getUri(), cached.getExternalResourceMetaData());
            }
            boolean bl = hasLocalCandidates = additionalCandidates != null && !additionalCandidates.isNone();
            if (hasLocalCandidates) {
                LocallyAvailableResource local;
                HashCode remoteChecksum = remoteMetaData.getSha1();
                if (remoteChecksum == null) {
                    remoteChecksum = this.getResourceSha1(location, true);
                }
                if (remoteChecksum != null && (local = additionalCandidates.findByHashValue(remoteChecksum)) != null) {
                    LocallyAvailableExternalResource resource;
                    LOGGER.info("Found locally available resource with matching checksum: [{}, {}]", (Object)location, (Object)local.getFile());
                    try {
                        resource = this.copyCandidateToCache(location, fileStore, remoteMetaData, remoteChecksum, local);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException((Throwable)e);
                    }
                    if (resource != null) {
                        return resource;
                    }
                }
            }
            return this.copyToCache(location, fileStore, this.delegate.withProgressLogging().resource(location, true));
        });
    }

    @Nullable
    private HashCode getResourceSha1(ExternalResourceName location, boolean revalidate) {
        try {
            ExternalResourceName sha1Location = location.append(".sha1");
            ExternalResource resource = this.delegate.resource(sha1Location, revalidate);
            ExternalResourceReadResult result = resource.withContentIfPresent(inputStream -> {
                try {
                    String sha = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.US_ASCII);
                    if (sha.length() < 40) {
                        return HashCode.fromBytes((byte[])HashValue.parse((String)sha).asByteArray());
                    }
                    return HashCode.fromString((String)sha);
                }
                catch (IOException e) {
                    throw new UncheckedIOException((Throwable)e);
                }
            });
            return result == null ? null : (HashCode)result.getResult();
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Failed to download SHA1 for resource '%s'.", location), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private LocallyAvailableExternalResource copyCandidateToCache(ExternalResourceName source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, ExternalResourceMetaData remoteMetaData, HashCode remoteChecksum, LocallyAvailableResource local) throws IOException {
        File destination = this.temporaryFileProvider.createTemporaryFile("gradle_download", "bin", new String[0]);
        try {
            Files.copy((File)local.getFile(), (File)destination);
            HashCode localChecksum = this.checksumService.sha1(destination);
            if (!localChecksum.equals((Object)remoteChecksum)) {
                LocallyAvailableExternalResource locallyAvailableExternalResource = null;
                return locallyAvailableExternalResource;
            }
            LocallyAvailableExternalResource locallyAvailableExternalResource = this.moveIntoCache(source, destination, fileStore, remoteMetaData);
            return locallyAvailableExternalResource;
        }
        finally {
            destination.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private LocallyAvailableExternalResource copyToCache(ExternalResourceName source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, ExternalResource resource) {
        DownloadAction downloadAction = new DownloadAction(source);
        try {
            resource.withContentIfPresent((ExternalResource.ContentAction)downloadAction);
        }
        catch (Exception e) {
            throw ResourceExceptions.getFailed((URI)source.getUri(), (Throwable)e);
        }
        if (downloadAction.metaData == null) {
            return null;
        }
        try {
            LocallyAvailableExternalResource locallyAvailableExternalResource = this.moveIntoCache(source, downloadAction.destination, fileStore, downloadAction.metaData);
            return locallyAvailableExternalResource;
        }
        finally {
            downloadAction.destination.delete();
        }
    }

    private LocallyAvailableExternalResource moveIntoCache(ExternalResourceName source, File destination, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, ExternalResourceMetaData metaData) {
        return (LocallyAvailableExternalResource)this.artifactCacheLockingManager.useCache(() -> {
            LocallyAvailableResource cachedResource = fileStore.moveIntoCache(destination);
            File fileInFileStore = cachedResource.getFile();
            this.cachedExternalResourceIndex.store(source.toString(), fileInFileStore, metaData);
            return this.fileResourceRepository.resource(fileInFileStore, source.getUri(), metaData);
        });
    }

    private long getAgeMillis(BuildCommencedTimeProvider timeProvider, CachedExternalResource cached) {
        return timeProvider.getCurrentTime() - cached.getCachedAt();
    }

    private class DownloadAction
    implements ExternalResource.ContentAction<Object> {
        private final ExternalResourceName source;
        File destination;
        ExternalResourceMetaData metaData;

        DownloadAction(ExternalResourceName source) {
            this.source = source;
        }

        public Object execute(InputStream inputStream, ExternalResourceMetaData metaData) throws IOException {
            this.destination = DefaultCacheAwareExternalResourceAccessor.this.temporaryFileProvider.createTemporaryFile("gradle_download", "bin", new String[0]);
            this.metaData = metaData;
            LOGGER.info("Downloading {} to {}", (Object)this.source, (Object)this.destination);
            if (this.destination.getParentFile() != null) {
                GFileUtils.mkdirs((File)this.destination.getParentFile());
            }
            try (FileOutputStream outputStream = new FileOutputStream(this.destination);){
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            }
            return null;
        }
    }
}

