/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.Actions;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.util.Path;

public class TaskInAnotherBuild
extends TaskNode {
    protected IncludedBuildTaskResource.State state = IncludedBuildTaskResource.State.WAITING;
    private final Path taskIdentityPath;
    private final String taskPath;
    private final BuildIdentifier targetBuild;
    private final IncludedBuildTaskResource target;

    public static TaskInAnotherBuild of(TaskInternal task, IncludedBuildTaskGraph taskGraph) {
        BuildIdentifier targetBuild = TaskInAnotherBuild.buildIdentifierOf(task);
        IncludedBuildTaskResource taskResource = taskGraph.locateTask(targetBuild, task);
        return new TaskInAnotherBuild(task.getIdentityPath(), task.getPath(), targetBuild, taskResource);
    }

    public static TaskInAnotherBuild of(String taskPath, BuildIdentifier targetBuild, IncludedBuildTaskGraph taskGraph) {
        IncludedBuildTaskResource taskResource = taskGraph.locateTask(targetBuild, taskPath);
        Path taskIdentityPath = Path.path((String)targetBuild.getName()).append(Path.path((String)taskPath));
        return new TaskInAnotherBuild(taskIdentityPath, taskPath, targetBuild, taskResource);
    }

    protected TaskInAnotherBuild(Path taskIdentityPath, String taskPath, BuildIdentifier targetBuild, IncludedBuildTaskResource target) {
        this.taskIdentityPath = taskIdentityPath;
        this.taskPath = taskPath;
        this.targetBuild = targetBuild;
        this.target = target;
        this.doNotRequire();
    }

    public BuildIdentifier getTargetBuild() {
        return this.targetBuild;
    }

    public String getTaskPath() {
        return this.taskPath;
    }

    @Override
    public TaskInternal getTask() {
        return this.target.getTask();
    }

    @Override
    public void prepareForExecution() {
        this.target.queueForExecution();
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        return null;
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return null;
    }

    public List<ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    @Override
    public Throwable getNodeFailure() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rethrowNodeFailure() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendPostAction(Action<? super Task> action) {
    }

    @Override
    public Action<? super Task> getPostAction() {
        return Actions.doNothing();
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
    }

    @Override
    public boolean requiresMonitoring() {
        return true;
    }

    @Override
    public boolean isSuccessful() {
        return this.state == IncludedBuildTaskResource.State.SUCCESS;
    }

    @Override
    public boolean isFailed() {
        return this.state == IncludedBuildTaskResource.State.FAILED;
    }

    @Override
    public boolean isComplete() {
        if (this.state != IncludedBuildTaskResource.State.WAITING) {
            return true;
        }
        this.state = this.target.getTaskState();
        return this.state != IncludedBuildTaskResource.State.WAITING;
    }

    @Override
    public int compareTo(Node other) {
        if (this.getClass() != other.getClass()) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        TaskInAnotherBuild taskNode = (TaskInAnotherBuild)other;
        return this.taskIdentityPath.compareTo(taskNode.taskIdentityPath);
    }

    @Override
    public String toString() {
        return this.taskIdentityPath.toString();
    }

    @Override
    public void resolveMutations() {
    }

    private static BuildIdentifier buildIdentifierOf(TaskInternal task) {
        return ((ProjectInternal)task.getProject()).getOwner().getOwner().getBuildIdentifier();
    }
}

