/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class MerkleDirectorySnapshotBuilder {
    private static final HashCode DIR_SIGNATURE = Hashing.signature((String)"DIR");
    private final Deque<Directory> directoryStack = new ArrayDeque<Directory>();
    private final boolean sortingRequired;
    private FileSystemLocationSnapshot result;

    public static MerkleDirectorySnapshotBuilder sortingRequired() {
        return new MerkleDirectorySnapshotBuilder(true);
    }

    public static MerkleDirectorySnapshotBuilder noSortingRequired() {
        return new MerkleDirectorySnapshotBuilder(false);
    }

    private MerkleDirectorySnapshotBuilder(boolean sortingRequired) {
        this.sortingRequired = sortingRequired;
    }

    public void enterDirectory(DirectorySnapshot directorySnapshot, EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy) {
        this.enterDirectory(directorySnapshot.getAccessType(), directorySnapshot.getAbsolutePath(), directorySnapshot.getName(), emptyDirectoryHandlingStrategy);
    }

    public void enterDirectory(FileMetadata.AccessType accessType, String absolutePath, String name, EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy) {
        this.directoryStack.addLast(new Directory(accessType, absolutePath, name, emptyDirectoryHandlingStrategy));
    }

    public void visitLeafElement(FileSystemLeafSnapshot snapshot) {
        this.collectEntry(snapshot);
    }

    public void visitDirectory(DirectorySnapshot directorySnapshot) {
        this.collectEntry(directorySnapshot);
    }

    public boolean leaveDirectory() {
        DirectorySnapshot snapshot = this.directoryStack.removeLast().fold();
        if (snapshot == null) {
            return false;
        }
        this.collectEntry(snapshot);
        return true;
    }

    private void collectEntry(FileSystemLocationSnapshot snapshot) {
        Directory directory = this.directoryStack.peekLast();
        if (directory != null) {
            directory.collectEntry(snapshot);
        } else {
            assert (this.result == null);
            this.result = snapshot;
        }
    }

    @Nullable
    public FileSystemLocationSnapshot getResult() {
        return this.result;
    }

    private class Directory {
        private final FileMetadata.AccessType accessType;
        private final String absolutePath;
        private final String name;
        private final List<FileSystemLocationSnapshot> children;
        private final EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy;

        public Directory(FileMetadata.AccessType accessType, String absolutePath, String name, EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy) {
            this.accessType = accessType;
            this.absolutePath = absolutePath;
            this.name = name;
            this.children = new ArrayList<FileSystemLocationSnapshot>();
            this.emptyDirectoryHandlingStrategy = emptyDirectoryHandlingStrategy;
        }

        public void collectEntry(FileSystemLocationSnapshot snapshot) {
            this.children.add(snapshot);
        }

        @Nullable
        public DirectorySnapshot fold() {
            if (this.emptyDirectoryHandlingStrategy == EmptyDirectoryHandlingStrategy.EXCLUDE_EMPTY_DIRS && this.children.isEmpty()) {
                return null;
            }
            if (MerkleDirectorySnapshotBuilder.this.sortingRequired) {
                this.children.sort(FileSystemLocationSnapshot.BY_NAME);
            }
            Hasher hasher = Hashing.newHasher();
            hasher.putHash(DIR_SIGNATURE);
            for (FileSystemLocationSnapshot child : this.children) {
                hasher.putString((CharSequence)child.getName());
                hasher.putHash(child.getHash());
            }
            return new DirectorySnapshot(this.absolutePath, this.name, this.accessType, hasher.hash(), this.children);
        }
    }

    public static enum EmptyDirectoryHandlingStrategy {
        INCLUDE_EMPTY_DIRS,
        EXCLUDE_EMPTY_DIRS;

    }
}

